/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengfeizhou.jscore;

import com.github.pengfeizhou.jscore.JSValue;

public class JSArray
extends JSValue {
    private final JSValue[] mVal;

    public JSArray(int size) {
        this.mVal = new JSValue[size];
    }

    public void put(int index, JSValue val) {
        this.mVal[index] = val;
    }

    public JSValue get(int index) {
        return this.mVal[index];
    }

    public int size() {
        return this.mVal.length;
    }

    @Override
    public JSValue.JSType getJSType() {
        return JSValue.JSType.Array;
    }

    public JSValue.JSType value() {
        return JSValue.JSType.Array;
    }

    public JSValue[] toArray() {
        return this.mVal;
    }

    public String[] toStringArray() {
        String[] ret = new String[this.mVal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.mVal[i].asString().value();
        }
        return ret;
    }

    public boolean[] toBooleanArray() {
        boolean[] ret = new boolean[this.mVal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.mVal[i].asBoolean().value();
        }
        return ret;
    }

    public int[] toIntArray() {
        int[] ret = new int[this.mVal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.mVal[i].asNumber().toInt();
        }
        return ret;
    }

    public float[] toFloatArray() {
        float[] ret = new float[this.mVal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.mVal[i].asNumber().toFloat();
        }
        return ret;
    }

    public double[] toDoubleArray() {
        double[] ret = new double[this.mVal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.mVal[i].asNumber().toDouble();
        }
        return ret;
    }

    public long[] toLongArray() {
        long[] ret = new long[this.mVal.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.mVal[i].asNumber().toLong();
        }
        return ret;
    }
}

