package com.github.pengfeizhou.jscore;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * Created by pengfei on 2016/9/24.
 * <p>
 * 该类用于在Java与JS之间传递数据，
 * 该类不能被混淆
 */
public class JavaValue {
    protected static final int TYPE_NULL = 0;
    protected static final int TYPE_NUMBER = 1;
    protected static final int TYPE_BOOLEAN = 2;
    protected static final int TYPE_STRING = 3;
    protected static final int TYPE_OBJECT = 4;
    protected static final int TYPE_ARRAY = 5;
    protected JavaFunction[] functions = null;
    protected String[] functionNames = null;
    protected int type;
    protected String value = "";

    /**
     * 构造空对象
     */
    public JavaValue() {
        this.type = TYPE_NULL;
    }

    /**
     * 构造number
     */
    public JavaValue(double value) {
        this.value = String.valueOf(value);
        this.type = TYPE_NUMBER;
    }

    /**
     * 构造string
     */
    public JavaValue(String value) {
        this.value = String.valueOf(value);
        this.type = TYPE_STRING;
    }

    /**
     * 构造bool
     */
    public JavaValue(boolean value) {
        this.value = String.valueOf(value);
        this.type = TYPE_BOOLEAN;
    }

    /**
     * 构造复杂的JS对象，包括数据与方法
     */
    public JavaValue(Encoding object) {
        this.type = TYPE_OBJECT;
        this.value = object.encode().toString();
        this.functionNames = object.getFunctionNames();
        this.functions = object.getFunctions();
    }

    /**
     * 构造无方法的JS对象，只包含数据
     */
    public JavaValue(JSONObject json) {
        this.type = TYPE_OBJECT;
        this.value = json.toString();
    }

    /**
     * 构造无方法JS对象数组
     */
    public JavaValue(JSONArray jsonArray) {
        this.type = TYPE_ARRAY;
        this.value = jsonArray.toString();
    }

    /**
     * 构造复杂JS对象数组
     */
    public JavaValue(Encoding[] objects) {
        this.type = TYPE_ARRAY;
        JSONArray jsonArray = new JSONArray();
        for (Encoding object : objects) {
            jsonArray.put(object.encode());
        }
        this.value = jsonArray.toString();
    }

    public int getType() {
        return type;
    }

    public String getValue() {
        return value;
    }
}