package com.github.pengfeizhou.jscore;

/**
 * Define js number
 * Created by pengfei.zhou on 2018/12/12.
 */
public class JSNumber extends JSValue {
    private final double mVal;

    public JSNumber(double b) {
        this.mVal = b;
    }

    @Override
    public JSType getJSType() {
        return JSType.Number;
    }

    @Override
    public Double value() {
        return mVal;
    }

    public int toInt() {
        return (int) mVal;
    }

    public float toFloat() {
        return (float) mVal;
    }

    public long toLong() {
        return (long) mVal;
    }

    public double toDouble() {
        return mVal;
    }
}
