package com.github.pengfeizhou.jscore;

/**
 * Define JS Array
 * Created by pengfei.zhou on 2018/12/12.
 */
public class JSArray extends JSValue {
    private final JSValue[] mVal;

    public JSArray(int size) {
        mVal = new JSValue[size];
    }

    public void put(int index, JSValue val) {
        mVal[index] = val;
    }

    public JSValue get(int index) {
        return mVal[index];
    }

    public int size() {
        return mVal.length;
    }

    @Override
    public JSType getJSType() {
        return JSType.Array;
    }

    @Override
    public JSType value() {
        return JSType.Array;
    }

    public JSValue[] toArray() {
        return mVal;
    }

    public String[] toStringArray() {
        String[] ret = new String[mVal.length];
        for (int i = 0; i < ret.length; i++) {
            ret[i] = mVal[i].asString().value();
        }
        return ret;
    }

    public boolean[] toBooleanArray() {
        boolean[] ret = new boolean[mVal.length];
        for (int i = 0; i < ret.length; i++) {
            ret[i] = mVal[i].asBoolean().value();
        }
        return ret;
    }

    public int[] toIntArray() {
        int[] ret = new int[mVal.length];
        for (int i = 0; i < ret.length; i++) {
            ret[i] = mVal[i].asNumber().toInt();
        }
        return ret;
    }

    public float[] toFloatArray() {
        float[] ret = new float[mVal.length];
        for (int i = 0; i < ret.length; i++) {
            ret[i] = mVal[i].asNumber().toFloat();
        }
        return ret;
    }

    public double[] toDoubleArray() {
        double[] ret = new double[mVal.length];
        for (int i = 0; i < ret.length; i++) {
            ret[i] = mVal[i].asNumber().toDouble();
        }
        return ret;
    }

    public long[] toLongArray() {
        long[] ret = new long[mVal.length];
        for (int i = 0; i < ret.length; i++) {
            ret[i] = mVal[i].asNumber().toLong();
        }
        return ret;
    }
}
