/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.glide;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.github.penfeizhou.animation.apng.decode.APNGParser;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.gif.decode.GifParser;
import com.github.penfeizhou.animation.glide.AnimationDecoderOption;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.io.StreamReader;
import com.github.penfeizhou.animation.webp.decode.WebPParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class StreamAnimationDecoder
implements ResourceDecoder<InputStream, FrameSeqDecoder> {
    private final ResourceDecoder<ByteBuffer, FrameSeqDecoder> byteBufferDecoder;

    public StreamAnimationDecoder(ResourceDecoder<ByteBuffer, FrameSeqDecoder> byteBufferDecoder) {
        this.byteBufferDecoder = byteBufferDecoder;
    }

    public boolean handles(@NonNull InputStream source, @NonNull Options options) {
        return (Boolean)options.get(AnimationDecoderOption.DISABLE_ANIMATION_WEBP_DECODER) == false && WebPParser.isAWebP((Reader)new StreamReader(source)) || (Boolean)options.get(AnimationDecoderOption.DISABLE_ANIMATION_APNG_DECODER) == false && APNGParser.isAPNG((Reader)new StreamReader(source)) || (Boolean)options.get(AnimationDecoderOption.DISABLE_ANIMATION_GIF_DECODER) == false && GifParser.isGif((Reader)new StreamReader(source));
    }

    @Nullable
    public Resource<FrameSeqDecoder> decode(@NonNull InputStream source, int width, int height, @NonNull Options options) throws IOException {
        byte[] data = StreamAnimationDecoder.inputStreamToBytes(source);
        if (data == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        return this.byteBufferDecoder.decode((Object)byteBuffer, width, height, options);
    }

    private static byte[] inputStreamToBytes(InputStream is) {
        int bufferSize = 16384;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
        try {
            int nRead;
            byte[] data = new byte[16384];
            while ((nRead = is.read(data)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            return null;
        }
        return buffer.toByteArray();
    }
}

