/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.tools4a.run;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.panpf.tools4a.run.ResultNullableRunnable;
import com.github.panpf.tools4a.run.ResultRunnable;
import com.github.panpf.tools4a.run.SyncResultNullableRunnable;
import com.github.panpf.tools4a.run.SyncResultRunnable;
import com.github.panpf.tools4a.run.SyncRunnable;
import java.util.List;

public class Runx {
    private Runx() {
    }

    @NonNull
    public static Handler getMainHandler() {
        return MainHandlerHolder.MAIN_HANDLER;
    }

    public static boolean isOnMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static boolean isOnNotMainThread() {
        return Looper.getMainLooper().getThread() != Thread.currentThread();
    }

    public static void checkMainThread() {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Method cannot be called on the not main application thread (on: " + Thread.currentThread().getName() + ")");
        }
    }

    public static void checkNotMainThread() {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            throw new IllegalStateException("Method cannot be called on the main application thread (on: " + Thread.currentThread().getName() + ")");
        }
    }

    public static void runOnMainThread(@NonNull Runnable block) {
        if (Runx.isOnMainThread()) {
            block.run();
        } else {
            Runx.getMainHandler().post(block);
        }
    }

    public static void runOnMainThreadSync(@NonNull Runnable block) {
        if (Runx.isOnMainThread()) {
            block.run();
        } else {
            SyncRunnable syncRunnable = new SyncRunnable(block);
            Runx.getMainHandler().post((Runnable)syncRunnable);
            syncRunnable.waitForComplete();
        }
    }

    @NonNull
    public static <T> T runOnMainThreadSyncResult(@NonNull ResultRunnable<T> block) {
        if (Runx.isOnMainThread()) {
            return block.run();
        }
        SyncResultRunnable<T> syncRunnable = new SyncResultRunnable<T>(block);
        Runx.getMainHandler().post(syncRunnable);
        return syncRunnable.waitForComplete();
    }

    @Nullable
    public static <T> T runOnMainThreadSyncResultNullable(@NonNull ResultNullableRunnable<T> block) {
        if (Runx.isOnMainThread()) {
            return block.run();
        }
        SyncResultNullableRunnable<T> syncRunnable = new SyncResultNullableRunnable<T>(block);
        Runx.getMainHandler().post(syncRunnable);
        return syncRunnable.waitForComplete();
    }

    public static boolean isOnMainProcess(@NonNull Context context) {
        return context.getPackageName().equals(Runx.getOnProcessNameOrNull(context));
    }

    public static boolean isOnNotMainProcess(@NonNull Context context) {
        return !context.getPackageName().equals(Runx.getOnProcessNameOrNull(context));
    }

    @Nullable
    public static String getOnProcessNameOrNull(@NonNull Context context) {
        int myPid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List processInfoList = activityManager.getRunningAppProcesses();
        if (processInfoList != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : processInfoList) {
                if (runningAppProcessInfo.pid != myPid) continue;
                return runningAppProcessInfo.processName;
            }
        }
        return null;
    }

    @Nullable
    public static String getOnProcessNameSuffixOrNull(@NonNull Context context) {
        String result;
        String processName = Runx.getOnProcessNameOrNull(context);
        if (processName == null) {
            return null;
        }
        String packageName = context.getPackageName();
        int lastIndex = processName.lastIndexOf(packageName, 0);
        String string = result = lastIndex != -1 ? processName.substring(lastIndex + packageName.length()) : null;
        if (result != null && result.startsWith(":")) {
            result = result.substring(1);
        }
        return result != null && !"".equals(result) ? result : null;
    }

    private static class MainHandlerHolder {
        private static final Handler MAIN_HANDLER = new Handler(Looper.getMainLooper());

        private MainHandlerHolder() {
        }
    }
}

