/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.tools4a.run;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.panpf.tools4a.run.ResultNullableRunnable;
import com.github.panpf.tools4a.run.ResultRunnable;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class Runx {
    private Runx() {
    }

    @NonNull
    public static Handler getMainHandler() {
        return MainHandlerHolder.MAIN_HANDLER;
    }

    public static void runOnUIThread(@NonNull Runnable block) {
        if (Runx.isOnTheMainThread()) {
            block.run();
        } else {
            Runx.getMainHandler().post(block);
        }
    }

    public static void runOnUIThreadAndWait(final @NonNull Runnable block) {
        if (Runx.isOnTheMainThread()) {
            block.run();
        } else {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Runx.getMainHandler().post(new Runnable(){

                @Override
                public void run() {
                    block.run();
                    countDownLatch.countDown();
                }
            });
            try {
                countDownLatch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @NonNull
    public static <T> T runOnUIThreadAndWaitResult(final @NonNull ResultRunnable<T> block) {
        if (Runx.isOnTheMainThread()) {
            return block.run();
        }
        final Object[] results = new Object[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Runx.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                results[0] = block.run();
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Object result = results[0];
        if (result != null) {
            return (T)result;
        }
        throw new IllegalArgumentException("return result cannot be null");
    }

    @Nullable
    public static <T> T runOnUIThreadAndWaitNullableResult(final @NonNull ResultNullableRunnable<T> block) {
        if (Runx.isOnTheMainThread()) {
            return block.run();
        }
        final Object[] results = new Object[1];
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        Runx.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                results[0] = block.run();
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return (T)results[0];
    }

    public static boolean isOnTheMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static boolean isOnTheMainProcess(@NonNull Context context) {
        return context.getPackageName().equals(Runx.getTheProcessName(context));
    }

    @Nullable
    public static String getTheProcessName(@NonNull Context context) {
        int myPid = Process.myPid();
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List processInfoList = activityManager.getRunningAppProcesses();
        if (processInfoList != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : processInfoList) {
                if (runningAppProcessInfo.pid != myPid) continue;
                return runningAppProcessInfo.processName;
            }
        }
        return null;
    }

    @Nullable
    public static String getTheProcessNameSuffix(@NonNull Context context) {
        String processName = Runx.getTheProcessName(context);
        if (processName == null) {
            return null;
        }
        String packageName = context.getPackageName();
        int lastIndex = processName.lastIndexOf(packageName, 0);
        return lastIndex != -1 ? processName.substring(lastIndex + packageName.length()) : null;
    }

    private static class MainHandlerHolder {
        private static final Handler MAIN_HANDLER = new Handler(Looper.getMainLooper());

        private MainHandlerHolder() {
        }
    }
}

