/*
 * Decompiled with CFR 0.152.
 */
package com.github.panpf.liveevent;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.util.Function;
import com.github.panpf.liveevent.Listener;
import com.github.panpf.liveevent.LiveEvent;
import com.github.panpf.liveevent.MediatorLiveEvent;

public class LiveEventTransformations {
    private LiveEventTransformations() {
    }

    @MainThread
    public static <X, Y> LiveEvent<Y> map(@NonNull LiveEvent<X> source, final @NonNull Function<X, Y> mapFunction) {
        final MediatorLiveEvent result = new MediatorLiveEvent();
        result.addSource(source, new Listener<X>(){

            @Override
            public void onChanged(@Nullable X x) {
                result.setValue(mapFunction.apply(x));
            }
        });
        return result;
    }

    @MainThread
    public static <X, Y> LiveEvent<Y> switchMap(@NonNull LiveEvent<X> source, final @NonNull Function<X, LiveEvent<Y>> switchMapFunction) {
        final MediatorLiveEvent result = new MediatorLiveEvent();
        result.addSource(source, new Listener<X>(){
            LiveEvent<Y> mSource;

            @Override
            public void onChanged(@Nullable X x) {
                LiveEvent newLiveEvent = (LiveEvent)switchMapFunction.apply(x);
                if (this.mSource == newLiveEvent) {
                    return;
                }
                if (this.mSource != null) {
                    result.removeSource(this.mSource);
                }
                this.mSource = newLiveEvent;
                if (this.mSource != null) {
                    result.addSource(this.mSource, new Listener<Y>(){

                        @Override
                        public void onChanged(@Nullable Y y) {
                            result.setValue(y);
                        }
                    });
                }
            }
        });
        return result;
    }
}

