/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.facebook;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdListener;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;

public final class FacebookAdapter
implements MediationInterstitialAdapter,
MediationBannerAdapter {
    private static final String TAG = "FacebookAdapter";
    private static final String PLACEMENT_PARAMETER = "pubid";
    private MediationBannerListener mBannerListener;
    private MediationInterstitialListener mInterstitialListener;
    private AdView mAdView;
    private RelativeLayout mWrappedAdView;
    private InterstitialAd mInterstitialAd;

    public void onDestroy() {
        if (this.mAdView != null) {
            this.mAdView.destroy();
        }
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public View getBannerView() {
        return this.mWrappedAdView;
    }

    public void requestBannerAd(Context context, MediationBannerListener listener, Bundle serverParameters, com.google.android.gms.ads.AdSize adSize, MediationAdRequest adRequest, Bundle mediationExtras) {
        if (context == null || serverParameters == null || adSize == null) {
            return;
        }
        this.mBannerListener = listener;
        String placementId = serverParameters.getString(PLACEMENT_PARAMETER);
        if (placementId == null) {
            Log.w((String)TAG, (String)"Fail to request banner Ad, placementId is null");
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 0);
            return;
        }
        AdSize facebookAdSize = this.getAdSize(context, adSize);
        if (facebookAdSize == null) {
            Log.w((String)TAG, (String)("The input ad size " + adSize.toString() + " is not supported at this moment."));
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 3);
            return;
        }
        this.mAdView = new AdView(context, placementId, facebookAdSize);
        this.mAdView.setAdListener((AdListener)new BannerListener());
        this.buildAdRequest(adRequest);
        RelativeLayout.LayoutParams wrappedLayoutParams = new RelativeLayout.LayoutParams(adSize.getWidthInPixels(context), adSize.getHeightInPixels(context));
        this.mWrappedAdView = new RelativeLayout(context);
        this.mWrappedAdView.setLayoutParams((ViewGroup.LayoutParams)wrappedLayoutParams);
        this.mWrappedAdView.addView((View)this.mAdView);
        this.mAdView.loadAd();
    }

    public void requestInterstitialAd(Context context, MediationInterstitialListener listener, Bundle serverParameters, MediationAdRequest adRequest, Bundle mediationExtras) {
        if (context == null || serverParameters == null) {
            return;
        }
        this.mInterstitialListener = listener;
        String placementId = serverParameters.getString(PLACEMENT_PARAMETER);
        if (placementId == null) {
            Log.w((String)TAG, (String)"Fail to request interstitial Ad, placementId is null");
            this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)this, 0);
            return;
        }
        this.mInterstitialAd = new InterstitialAd(context, placementId);
        this.mInterstitialAd.setAdListener((InterstitialAdListener)new InterstitialListener());
        this.buildAdRequest(adRequest);
        this.mInterstitialAd.loadAd();
    }

    public void showInterstitial() {
        if (this.mInterstitialAd.isAdLoaded()) {
            this.mInterstitialAd.show();
        }
    }

    private int convertErrorCode(AdError adError) {
        if (adError == null) {
            return 0;
        }
        int errorCode = adError.getErrorCode();
        if (errorCode == 2001 || errorCode == 2000) {
            return 0;
        }
        if (errorCode == 1000) {
            return 2;
        }
        if (errorCode == 1002) {
            return 1;
        }
        return 3;
    }

    private void buildAdRequest(MediationAdRequest adRequest) {
        if (adRequest != null) {
            AdSettings.setIsChildDirected((adRequest.taggedForChildDirectedTreatment() == 1 ? 1 : 0) != 0);
        }
    }

    private AdSize getAdSize(Context context, com.google.android.gms.ads.AdSize adSize) {
        if (adSize.getWidth() == AdSize.BANNER_320_50.getWidth() && adSize.getHeight() == AdSize.BANNER_320_50.getHeight()) {
            return AdSize.BANNER_320_50;
        }
        int heightInDip = this.pixelToDip(adSize.getHeightInPixels(context));
        if (heightInDip == AdSize.BANNER_HEIGHT_50.getHeight()) {
            return AdSize.BANNER_HEIGHT_50;
        }
        if (heightInDip == AdSize.BANNER_HEIGHT_90.getHeight()) {
            return AdSize.BANNER_HEIGHT_90;
        }
        if (heightInDip == AdSize.RECTANGLE_HEIGHT_250.getHeight()) {
            return AdSize.RECTANGLE_HEIGHT_250;
        }
        return null;
    }

    private int pixelToDip(int pixel) {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        return Math.round((float)pixel / displayMetrics.density);
    }

    private class BannerListener
    implements AdListener {
        private BannerListener() {
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mBannerListener.onAdClicked((MediationBannerAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mBannerListener.onAdOpened((MediationBannerAdapter)FacebookAdapter.this);
        }

        public void onAdLoaded(Ad ad) {
            FacebookAdapter.this.mBannerListener.onAdLoaded((MediationBannerAdapter)FacebookAdapter.this);
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = adError.getErrorMessage();
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)FacebookAdapter.this, FacebookAdapter.this.convertErrorCode(adError));
        }
    }

    private class InterstitialListener
    implements InterstitialAdListener {
        private InterstitialListener() {
        }

        public void onAdClicked(Ad ad) {
        }

        public void onAdLoaded(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdLoaded((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = adError.getErrorMessage();
            if (!TextUtils.isEmpty((CharSequence)errorMessage)) {
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)FacebookAdapter.this, FacebookAdapter.this.convertErrorCode(adError));
        }

        public void onInterstitialDismissed(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdClosed((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onInterstitialDisplayed(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdOpened((MediationInterstitialAdapter)FacebookAdapter.this);
        }
    }
}

