/*
 * Decompiled with CFR 0.152.
 */
package com.github.packageurl;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.util.SortedMap;
import java.util.TreeMap;

public final class PackageURLBuilder {
    private String type = null;
    private String namespace = null;
    private String name = null;
    private String version = null;
    private String subpath = null;
    private TreeMap<String, String> qualifiers = null;

    private PackageURLBuilder() {
    }

    public static PackageURLBuilder aPackageURL() {
        return new PackageURLBuilder();
    }

    public PackageURLBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public PackageURLBuilder withNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public PackageURLBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public PackageURLBuilder withVersion(String version) {
        this.version = version;
        return this;
    }

    public PackageURLBuilder withSubpath(String subpath) {
        this.subpath = subpath;
        return this;
    }

    public PackageURLBuilder withQualifier(String key, String value) {
        if (this.qualifiers == null) {
            this.qualifiers = new TreeMap();
        }
        this.qualifiers.put(key, value);
        return this;
    }

    public PackageURLBuilder withoutQualifier(String key) {
        if (this.qualifiers != null) {
            this.qualifiers.remove(key);
            if (this.qualifiers.isEmpty()) {
                this.qualifiers = null;
            }
        }
        return this;
    }

    public PackageURLBuilder withNoQualifiers() {
        this.qualifiers = null;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSubpath() {
        return this.subpath;
    }

    public TreeMap<String, String> getQualifiers() {
        if (this.qualifiers == null) {
            return new TreeMap<String, String>();
        }
        return new TreeMap<String, String>((SortedMap<String, String>)this.qualifiers);
    }

    public String getQualifier(String key) {
        if (this.qualifiers == null) {
            return null;
        }
        return this.qualifiers.get(key);
    }

    public PackageURL build() throws MalformedPackageURLException {
        return new PackageURL(this.type, this.namespace, this.name, this.version, this.qualifiers, this.subpath);
    }
}

