/*
 * Decompiled with CFR 0.152.
 */
package com.github.oowekyala.ooxml.messages;

import com.github.oowekyala.ooxml.messages.ErrorCleaner;
import com.github.oowekyala.ooxml.messages.NiceXmlMessageSpec;
import com.github.oowekyala.ooxml.messages.OoxmlFacade;
import com.github.oowekyala.ooxml.messages.XmlException;
import com.github.oowekyala.ooxml.messages.XmlPosition;
import com.github.oowekyala.ooxml.messages.XmlPositioner;
import com.github.oowekyala.ooxml.messages.XmlSeverity;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class MessageUtil {
    private static final String KIND_SCHEMA_VALIDATION = "Schema validation";
    private static final String KIND_PARSING = "XML parsing";

    MessageUtil() {
    }

    static String enquote(String it) {
        return "'" + it + "'";
    }

    static XmlPosition extractPosition(Throwable throwable) {
        if (throwable instanceof XmlException) {
            return ((XmlException)throwable).getPosition();
        }
        if (throwable instanceof SAXParseException) {
            SAXParseException e = (SAXParseException)throwable;
            return new XmlPosition(e.getSystemId(), e.getLineNumber(), e.getColumnNumber());
        }
        if (throwable instanceof TransformerException) {
            if (throwable.getCause() instanceof SAXParseException) {
                return MessageUtil.extractPosition(throwable.getCause());
            }
            SourceLocator locator = ((TransformerException)throwable).getLocator();
            if (locator != null) {
                return new XmlPosition(locator.getSystemId(), locator.getLineNumber(), locator.getColumnNumber());
            }
        }
        return XmlPosition.UNDEFINED;
    }

    static XmlException createEntryBestEffort(OoxmlFacade ooxml, XmlPositioner positioner, XmlSeverity severity, Throwable exception) {
        String kind = MessageUtil.extractKind(exception);
        XmlPosition pos = MessageUtil.extractPosition(exception);
        String simpleMessage = MessageUtil.extractSimpleMessage(exception);
        NiceXmlMessageSpec spec = new NiceXmlMessageSpec(pos, simpleMessage).withKind(kind).withSeverity(severity).withCause(exception);
        String fullMessage = ooxml.getFormatter().formatSpec(ooxml, spec, positioner);
        return new XmlException(spec, fullMessage);
    }

    private static String extractKind(Throwable exception) {
        return exception instanceof SAXParseException && ErrorCleaner.isSchemaValidationMessage(exception.getMessage()) ? KIND_SCHEMA_VALIDATION : KIND_PARSING;
    }

    private static String extractSimpleMessage(Throwable exception) {
        String simpleMessage = exception instanceof TransformerException && exception.getCause() instanceof SAXException ? exception.getCause().getMessage() : exception.getMessage();
        return simpleMessage;
    }

    static String readFully(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buf = new char[8192];
        int read = reader.read(buf);
        while (read >= 0) {
            writer.write(buf, 0, read);
            read = reader.read(buf);
        }
        return writer.toString();
    }

    public static String headerOnly(NiceXmlMessageSpec spec, String message, boolean singleLine) {
        String url = spec.getPosition().getSystemId();
        String header = spec.getSeverity().toString();
        String kind = spec.getKind();
        if (kind != null) {
            header = header + " (" + kind + ")";
        }
        if (url != null) {
            header = spec.getPosition().isUndefined() ? header + " in " + url : header + " at " + url + ":" + spec.getPosition().getLine() + ":" + spec.getPosition().getColumn();
        }
        if (singleLine) {
            return header + " - " + message;
        }
        return header + "\n" + message;
    }
}

