/*
 * Decompiled with CFR 0.152.
 */
package com.github.oowekyala.ooxml.messages;

import com.github.oowekyala.ooxml.messages.InternalUtil;
import com.github.oowekyala.ooxml.messages.MessageUtil;
import com.github.oowekyala.ooxml.messages.NiceXmlMessageSpec;
import com.github.oowekyala.ooxml.messages.OoxmlFacade;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ContextLines {
    private final int first;
    private final int errorIdx;
    private final List<String> lines;

    ContextLines(List<String> lines, int first, int errorIdx) {
        this.lines = lines;
        this.first = first;
        this.errorIdx = errorIdx;
        assert (first > 0) : "line num is one based";
        assert (0 <= errorIdx && errorIdx < lines.size()) : "Weird indices --- first=" + first + ", errorIdx=" + errorIdx + ", lines=" + lines;
    }

    String make(OoxmlFacade ooxml, NiceXmlMessageSpec spec) {
        int pad = this.stringLengthOf(this.lines.size() + this.first - 1);
        List withLineNums = IntStream.range(0, this.lines.size()).mapToObj(i -> this.addLineNum(i, pad)).collect(Collectors.collectingAndThen(Collectors.toList(), ArrayList::new));
        String errorLine = this.addLineNum(this.errorIdx, pad);
        int offset = errorLine.length() - this.lines.get(this.errorIdx).length();
        String messageLine = InternalUtil.buildCaretLine(spec.getSimpleMessage().trim(), spec.getPosition().getColumn() + offset - 1, spec.getPosition().getLength());
        String colored = ooxml.isUseAnsiColors() ? spec.getSeverity().withColor(messageLine) : messageLine;
        withLineNums.add(this.errorIdx + 1, colored);
        withLineNums.add(this.errorIdx + 2, "");
        return MessageUtil.headerOnly(spec, String.join((CharSequence)"\n", withLineNums), false);
    }

    private int stringLengthOf(int i) {
        return (i + "").length();
    }

    private String addLineNum(int idx, int pad) {
        return String.format(" %" + pad + "d| %s", idx + this.first, this.lines.get(idx));
    }
}

