/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.stateview;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.github.nukc.stateview.R;

public class StateView
extends View {
    private int mEmptyResource;
    private int mRetryResource;
    private int mLoadingResource;
    private View mEmptyView;
    private View mRetryView;
    private View mLoadingView;
    private LayoutInflater mInflater;
    private OnRetryClickListener mRetryClickListener;
    private RelativeLayout.LayoutParams mLayoutParams;

    public static StateView inject(@NonNull Activity activity) {
        return StateView.inject(activity, false);
    }

    public static StateView inject(@NonNull Activity activity, boolean hasActionBar) {
        ViewGroup rootView = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        return StateView.inject(rootView, hasActionBar);
    }

    public static StateView inject(@NonNull ViewGroup parent) {
        return StateView.inject(parent, false);
    }

    public static StateView inject(@NonNull ViewGroup parent, boolean hasActionBar) {
        if (parent instanceof LinearLayout || parent instanceof ScrollView || parent instanceof AdapterView) {
            FrameLayout root = new FrameLayout(parent.getContext());
            root.setLayoutParams(parent.getLayoutParams());
            ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
            parent.setLayoutParams(layoutParams);
            ViewParent viewParent = parent.getParent();
            if (viewParent instanceof ViewGroup) {
                ViewGroup rootGroup = (ViewGroup)viewParent;
                rootGroup.removeView((View)parent);
                rootGroup.addView((View)root);
            }
            root.addView((View)parent);
            parent = root;
        }
        StateView stateView = new StateView(parent.getContext());
        parent.addView((View)stateView);
        if (hasActionBar) {
            stateView.setTopMargin();
        }
        return stateView;
    }

    public static StateView inject(@NonNull View view) {
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            return StateView.inject(parent);
        }
        throw new ClassCastException("view must be ViewGroup");
    }

    public static StateView inject(@NonNull View view, boolean hasActionBar) {
        if (view instanceof ViewGroup) {
            ViewGroup parent = (ViewGroup)view;
            return StateView.inject(parent, hasActionBar);
        }
        throw new ClassCastException("view must be ViewGroup");
    }

    public StateView(Context context) {
        this(context, null);
    }

    public StateView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StateView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StateView);
        this.mEmptyResource = a.getResourceId(R.styleable.StateView_emptyResource, 0);
        this.mRetryResource = a.getResourceId(R.styleable.StateView_retryResource, 0);
        this.mLoadingResource = a.getResourceId(R.styleable.StateView_loadingResource, 0);
        a.recycle();
        if (this.mEmptyResource == 0) {
            this.mEmptyResource = R.layout.base_empty;
        }
        if (this.mRetryResource == 0) {
            this.mRetryResource = R.layout.base_retry;
        }
        if (this.mLoadingResource == 0) {
            this.mLoadingResource = R.layout.base_loading;
        }
        this.mLayoutParams = attrs == null ? new RelativeLayout.LayoutParams(-1, -1) : new RelativeLayout.LayoutParams(context, attrs);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(Canvas canvas) {
    }

    protected void dispatchDraw(Canvas canvas) {
    }

    public void setVisibility(int visibility) {
        this.setVisibility(this.mEmptyView, visibility);
        this.setVisibility(this.mRetryView, visibility);
        this.setVisibility(this.mLoadingView, visibility);
    }

    private void setVisibility(View view, int visibility) {
        if (view != null) {
            view.setVisibility(visibility);
        }
    }

    public void showContent() {
        this.setVisibility(8);
    }

    public View showEmpty() {
        if (this.mEmptyView == null) {
            this.mEmptyView = this.inflate(this.mEmptyResource);
        }
        this.showView(this.mEmptyView);
        return this.mEmptyView;
    }

    public View showRetry() {
        if (this.mRetryView == null) {
            this.mRetryView = this.inflate(this.mRetryResource);
            this.mRetryView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (StateView.this.mRetryClickListener != null) {
                        StateView.this.showLoading();
                        StateView.this.mRetryView.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                StateView.this.mRetryClickListener.onRetryClick();
                            }
                        }, 200L);
                    }
                }
            });
        }
        this.showView(this.mRetryView);
        return this.mRetryView;
    }

    public View showLoading() {
        if (this.mLoadingView == null) {
            this.mLoadingView = this.inflate(this.mLoadingResource);
        }
        this.showView(this.mLoadingView);
        return this.mLoadingView;
    }

    private void showView(View view) {
        this.setVisibility(view, 0);
        if (this.mEmptyView == view) {
            this.setVisibility(this.mLoadingView, 8);
            this.setVisibility(this.mRetryView, 8);
        } else if (this.mLoadingView == view) {
            this.setVisibility(this.mEmptyView, 8);
            this.setVisibility(this.mRetryView, 8);
        } else {
            this.setVisibility(this.mEmptyView, 8);
            this.setVisibility(this.mLoadingView, 8);
        }
    }

    public View inflate(@LayoutRes int layoutResource) {
        ViewParent viewParent = this.getParent();
        if (viewParent != null && viewParent instanceof ViewGroup) {
            if (layoutResource != 0) {
                ViewGroup parent = (ViewGroup)viewParent;
                LayoutInflater factory = this.mInflater != null ? this.mInflater : LayoutInflater.from((Context)this.getContext());
                View view = factory.inflate(layoutResource, parent, false);
                int index = parent.indexOfChild((View)this);
                view.setClickable(true);
                ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                if (layoutParams != null) {
                    if (parent instanceof RelativeLayout) {
                        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)layoutParams;
                        this.mLayoutParams.setMargins(lp.leftMargin, lp.topMargin, lp.rightMargin, lp.bottomMargin);
                        parent.addView(view, index, (ViewGroup.LayoutParams)this.mLayoutParams);
                    } else {
                        parent.addView(view, index, layoutParams);
                    }
                } else {
                    parent.addView(view, index);
                }
                if (this.mLoadingView != null && this.mRetryView != null && this.mEmptyView != null) {
                    parent.removeViewInLayout((View)this);
                }
                return view;
            }
            throw new IllegalArgumentException("StateView must have a valid layoutResource");
        }
        throw new IllegalStateException("StateView must have a non-null ViewGroup viewParent");
    }

    public void setTopMargin() {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.getLayoutParams();
        layoutParams.topMargin = this.getActionBarHeight();
    }

    private int getActionBarHeight() {
        int height = 0;
        TypedValue tv = new TypedValue();
        if (this.getContext().getTheme().resolveAttribute(R.attr.actionBarSize, tv, true)) {
            height = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)this.getResources().getDisplayMetrics());
        }
        return height;
    }

    public void setEmptyResource(@LayoutRes int emptyResource) {
        this.mEmptyResource = emptyResource;
    }

    public void setRetryResource(@LayoutRes int retryResource) {
        this.mRetryResource = retryResource;
    }

    public void setLoadingResource(@LayoutRes int loadingResource) {
        this.mLoadingResource = loadingResource;
    }

    public LayoutInflater getInflater() {
        return this.mInflater;
    }

    public void setInflater(LayoutInflater inflater) {
        this.mInflater = inflater;
    }

    public void setOnRetryClickListener(OnRetryClickListener listener) {
        this.mRetryClickListener = listener;
    }

    public static interface OnRetryClickListener {
        public void onRetryClick();
    }
}

