/*
 * Decompiled with CFR 0.152.
 */
package com.github.nukc.recycleradapter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.github.nukc.recycleradapter.RecyclerHolder;
import java.util.ArrayList;
import java.util.List;

abstract class BaseAdapter<T>
extends RecyclerView.Adapter<RecyclerHolder> {
    protected List<T> mDataList;

    public BaseAdapter() {
        this.mDataList = new ArrayList<T>(0);
    }

    public BaseAdapter(List<T> dataList) {
        this.mDataList = dataList;
    }

    public int getItemCount() {
        return this.mDataList.size();
    }

    public View inflate(ViewGroup parent, @LayoutRes int resource) {
        return LayoutInflater.from((Context)parent.getContext()).inflate(resource, parent, false);
    }

    public T getItem(int position) {
        return this.mDataList.get(position);
    }

    public List<T> getDataList() {
        return this.mDataList;
    }

    public void refresh(List<T> dataList) {
        this.mDataList.clear();
        this.mDataList.addAll(dataList);
        this.notifyDataSetChanged();
    }

    public void add(int position, T date) {
        this.mDataList.add(position, date);
        this.notifyItemInserted(position);
    }

    public void add(T data) {
        this.add(this.mDataList.size(), data);
    }

    public void addAll(int positionStart, List<T> dataList) {
        this.mDataList.addAll(positionStart, dataList);
        this.notifyItemRangeInserted(positionStart, dataList.size());
    }

    public void addAll(List<T> dataList) {
        this.addAll(this.mDataList.size(), dataList);
    }

    public void move(int fromPosition, int toPosition) {
        T remove = this.mDataList.remove(fromPosition);
        this.mDataList.add(toPosition, remove);
        this.notifyItemMoved(fromPosition, toPosition);
    }

    public void change(int position, T data) {
        this.mDataList.remove(position);
        this.mDataList.add(position, data);
        this.notifyItemChanged(position);
    }

    public void remove(int position) {
        this.mDataList.remove(position);
        this.notifyItemRemoved(position);
    }

    public void clear() {
        this.mDataList.clear();
        this.notifyDataSetChanged();
    }
}

