/*
 * Decompiled with CFR 0.152.
 */
package com.github.gradle.node.exec;

import com.github.gradle.node.exec.ExecConfiguration;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"computeEnvironment", "", "", "execConfiguration", "Lcom/github/gradle/node/exec/ExecConfiguration;", "computeWorkingDir", "Ljava/io/File;", "nodeProjectDir", "Lorg/gradle/api/file/DirectoryProperty;", "gradle-node-plugin"})
public final class ExecRunnerKt {
    @NotNull
    public static final Map<String, String> computeEnvironment(@NotNull ExecConfiguration execConfiguration) {
        Intrinsics.checkNotNullParameter((Object)execConfiguration, (String)"execConfiguration");
        Map execEnvironment = new LinkedHashMap();
        Object object = execEnvironment;
        Map<String, String> map = System.getenv();
        Intrinsics.checkNotNullExpressionValue(map, (String)"System.getenv()");
        Map<String, String> map2 = map;
        object.putAll(map2);
        object = execEnvironment;
        map2 = execConfiguration.getEnvironment();
        object.putAll(map2);
        object = execConfiguration.getAdditionalBinPaths();
        if (!object.isEmpty()) {
            String pathEnvironmentVariableName = execEnvironment.get("Path") != null ? "Path" : "PATH";
            String actualPath = (String)execEnvironment.get(pathEnvironmentVariableName);
            Iterable iterable = execConfiguration.getAdditionalBinPaths();
            String string = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.pathSeparator");
            String additionalPathsSerialized = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
            execEnvironment.put(pathEnvironmentVariableName, additionalPathsSerialized + File.pathSeparator + actualPath);
        }
        return execEnvironment;
    }

    @Nullable
    public static final File computeWorkingDir(@NotNull DirectoryProperty nodeProjectDir, @NotNull ExecConfiguration execConfiguration) {
        Intrinsics.checkNotNullParameter((Object)nodeProjectDir, (String)"nodeProjectDir");
        Intrinsics.checkNotNullParameter((Object)execConfiguration, (String)"execConfiguration");
        File file = execConfiguration.getWorkingDir();
        if (file == null) {
            Object object = nodeProjectDir.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"nodeProjectDir.get()");
            File file2 = ((Directory)object).getAsFile();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"nodeProjectDir.get().asFile");
        }
        File workingDir = file;
        workingDir.mkdirs();
        return workingDir;
    }
}

