/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.lantern;

import android.app.Activity;
import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.Context;
import android.os.Handler;
import android.support.annotation.RequiresPermission;
import github.nisrulz.lantern.DisplayLightController;
import github.nisrulz.lantern.DisplayLightControllerImpl;
import github.nisrulz.lantern.FlashController;
import github.nisrulz.lantern.PostMarshmallow;
import github.nisrulz.lantern.PreMarshmallow;
import github.nisrulz.lantern.Utils;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

public class Lantern
implements LifecycleObserver {
    private WeakReference<Activity> activityWeakRef;
    private final DisplayLightController displayLightController;
    private FlashController flashController;
    private final Handler handler;
    private boolean isFlashOn = false;
    private long pulseTime = 1000L;
    private final Utils utils;
    private final Runnable pulseRunnable = new Runnable(){

        @Override
        public void run() {
            Lantern.this.enableTorchMode(!Lantern.this.isFlashOn);
            Lantern.this.handler.postDelayed(Lantern.this.pulseRunnable, Lantern.this.pulseTime);
        }
    };

    public Lantern(Activity activity) {
        this.activityWeakRef = new WeakReference<Activity>(activity);
        this.utils = new Utils();
        this.handler = new Handler();
        this.displayLightController = new DisplayLightControllerImpl(activity);
    }

    public Lantern alwaysOnDisplay(boolean enabled) {
        if (enabled) {
            this.displayLightController.enableAlwaysOnMode();
        } else {
            this.displayLightController.disableAlwaysOnMode();
        }
        return this;
    }

    public Lantern autoBright(boolean enabled) {
        if (enabled) {
            this.displayLightController.enableAutoBrightMode();
        } else {
            this.displayLightController.disableAutoBrightMode();
        }
        return this;
    }

    public Lantern checkAndRequestSystemPermission() {
        this.displayLightController.requestSystemWritePermission();
        return this;
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void cleanup() {
        this.handler.removeCallbacks(this.pulseRunnable);
        this.displayLightController.cleanup();
        this.activityWeakRef = null;
    }

    public Lantern enableTorchMode(boolean enabled) {
        if (this.activityWeakRef != null) {
            if (enabled) {
                if (!this.isFlashOn && this.utils.checkForCameraPermission(((Activity)this.activityWeakRef.get()).getApplicationContext())) {
                    this.flashController.on();
                    this.isFlashOn = true;
                }
            } else if (this.isFlashOn && this.utils.checkForCameraPermission(((Activity)this.activityWeakRef.get()).getApplicationContext())) {
                this.flashController.off();
                this.isFlashOn = false;
            }
        } else {
            this.flashController.off();
            this.isFlashOn = false;
        }
        return this;
    }

    public Lantern fullBrightDisplay(boolean enabled) {
        if (enabled) {
            this.displayLightController.enableFullBrightMode();
        } else {
            this.displayLightController.disableFullBrightMode();
        }
        return this;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public boolean initTorch() {
        if (this.activityWeakRef != null && this.utils.checkIfCameraFeatureExists((Context)this.activityWeakRef.get()) && this.utils.checkForCameraPermission((Context)this.activityWeakRef.get())) {
            this.flashController = Utils.isMarshmallowAndAbove() ? new PostMarshmallow((Context)this.activityWeakRef.get()) : new PreMarshmallow();
            return true;
        }
        return false;
    }

    public Lantern observeLifecycle(LifecycleOwner lifecycleOwner) {
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
        return this;
    }

    public Lantern pulse(boolean enabled) {
        if (enabled) {
            this.handler.postDelayed(this.pulseRunnable, this.pulseTime);
        } else {
            this.handler.removeCallbacks(this.pulseRunnable);
        }
        return this;
    }

    public Lantern withDelay(long time, TimeUnit timeUnit) {
        this.pulseTime = TimeUnit.MILLISECONDS.convert(time, timeUnit);
        return this;
    }
}

