/*
 * Decompiled with CFR 0.152.
 */
package github.nisrulz.lantern;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.RequiresPermission;
import android.view.Window;
import android.view.WindowManager;
import github.nisrulz.lantern.PostLollipop;
import github.nisrulz.lantern.PreLollipop;

public class Lantern {
    private boolean isFlashOn = false;
    private PostLollipop postLollipop;
    private PreLollipop preLollipop;

    private Lantern() {
    }

    public static Lantern getInstance() {
        return LazyHolder.INSTANCE;
    }

    public void init(Context context) {
        if (this.checkFeature(context, "android.hardware.camera.flash") && this.checkPermissions(context, "android.permission.CAMERA")) {
            if (this.isLollipopAndAbove()) {
                this.postLollipop = new PostLollipop(context);
            } else {
                this.preLollipop = new PreLollipop();
            }
        }
    }

    public void turnOnFlashlight() {
        if (!this.isFlashOn) {
            if (this.isLollipopAndAbove()) {
                this.postLollipop.turnOn();
            } else {
                this.preLollipop.turnOn();
            }
            this.isFlashOn = true;
        }
    }

    public void turnOffFlashlight() {
        if (this.isFlashOn) {
            if (this.isLollipopAndAbove()) {
                this.postLollipop.turnOff();
            } else {
                this.preLollipop.turnOff();
            }
            this.isFlashOn = false;
        }
    }

    public void clearKeepDisplayOn(Activity activity) {
        activity.getWindow().clearFlags(128);
    }

    public void keepDisplayOn(Activity activity) {
        activity.getWindow().addFlags(128);
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public void setDisplayToFullBright(Activity activity) {
        Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode", (int)0);
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.screenBrightness = 1.0f;
        window.setAttributes(layoutParams);
    }

    @RequiresPermission(value="android.permission.WRITE_SETTINGS")
    public void resetDisplayToAutoBright(Activity activity) {
        Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode", (int)1);
    }

    public boolean checkSystemWritePermission(Activity activity) {
        boolean retVal = true;
        if (Build.VERSION.SDK_INT >= 23) {
            retVal = Settings.System.canWrite((Context)activity);
        }
        return retVal;
    }

    public void requestSystemWritePermission(Activity activity) {
        if (Build.VERSION.SDK_INT >= 23) {
            Intent intent = new Intent("android.settings.action.MANAGE_WRITE_SETTINGS");
            intent.setData(Uri.parse((String)("package:" + activity.getPackageName())));
            activity.startActivity(intent);
        }
    }

    private boolean isLollipopAndAbove() {
        return Build.VERSION.SDK_INT > 21;
    }

    public boolean checkPermissions(Context context, String permission2) {
        return context.checkCallingOrSelfPermission(permission2) == 0;
    }

    public boolean checkFeature(Context context, String feature) {
        return context.getPackageManager().hasSystemFeature(feature);
    }

    private static class LazyHolder {
        static final Lantern INSTANCE = new Lantern();

        private LazyHolder() {
        }
    }
}

