/*
 * Decompiled with CFR 0.152.
 */
package com.github.niqdev.mjpeg;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import androidx.annotation.StyleableRes;
import com.github.niqdev.mjpeg.AbstractMjpegView;
import com.github.niqdev.mjpeg.DisplayMode;
import com.github.niqdev.mjpeg.Mjpeg;
import com.github.niqdev.mjpeg.MjpegInputStream;
import com.github.niqdev.mjpeg.MjpegView;
import com.github.niqdev.mjpeg.MjpegViewDefault;
import com.github.niqdev.mjpeg.MjpegViewNative;
import com.github.niqdev.mjpeg.OnFrameCapturedListener;
import com.github.niqdev.mjpeg.R;

public class MjpegSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback,
MjpegView {
    private MjpegView mMjpegView;
    private static final int DEFAULT_TYPE = 0;
    private static final SparseArray<Mjpeg.Type> TYPE = new SparseArray();

    public MjpegSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        boolean transparentBackground = this.getPropertyBoolean(attrs, R.styleable.MjpegSurfaceView, R.styleable.MjpegSurfaceView_transparentBackground);
        int backgroundColor = this.getPropertyColor(attrs, R.styleable.MjpegSurfaceView, R.styleable.MjpegSurfaceView_backgroundColor);
        if (transparentBackground) {
            this.setZOrderOnTop(true);
            this.getHolder().setFormat(-2);
        }
        switch (this.getPropertyType(attrs, R.styleable.MjpegSurfaceView, R.styleable.MjpegSurfaceView_type)) {
            case DEFAULT: {
                this.mMjpegView = new MjpegViewDefault(this, this, transparentBackground);
                break;
            }
            case NATIVE: {
                this.mMjpegView = new MjpegViewNative(this, this, transparentBackground);
            }
        }
        if (this.mMjpegView != null && backgroundColor != -1) {
            this.setCustomBackgroundColor(backgroundColor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mjpeg.Type getPropertyType(AttributeSet attributeSet, @StyleableRes int[] attrs, int attrIndex) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, attrs, 0, 0);
        try {
            int typeIndex = typedArray.getInt(attrIndex, 0);
            Mjpeg.Type type = (Mjpeg.Type)((Object)TYPE.get(typeIndex));
            Mjpeg.Type type2 = type != null ? type : (Mjpeg.Type)((Object)TYPE.get(0));
            return type2;
        }
        finally {
            typedArray.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getPropertyBoolean(AttributeSet attributeSet, @StyleableRes int[] attrs, int attrIndex) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, attrs, 0, 0);
        try {
            boolean bl = typedArray.getBoolean(attrIndex, false);
            return bl;
        }
        finally {
            typedArray.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPropertyColor(AttributeSet attributeSet, @StyleableRes int[] attrs, int attrIndex) {
        TypedArray typedArray = this.getContext().getTheme().obtainStyledAttributes(attributeSet, attrs, 0, 0);
        try {
            int n = typedArray.getColor(attrIndex, -1);
            return n;
        }
        finally {
            typedArray.recycle();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        ((AbstractMjpegView)this.mMjpegView).onSurfaceCreated(holder);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        ((AbstractMjpegView)this.mMjpegView).onSurfaceChanged(holder, format, width, height);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        ((AbstractMjpegView)this.mMjpegView).onSurfaceDestroyed(holder);
    }

    @Override
    public void setSource(MjpegInputStream stream) {
        this.mMjpegView.setSource(stream);
    }

    @Override
    public void setDisplayMode(DisplayMode mode) {
        this.mMjpegView.setDisplayMode(mode);
    }

    @Override
    public void showFps(boolean show) {
        this.mMjpegView.showFps(show);
    }

    @Override
    public void flipSource(boolean flip) {
        this.mMjpegView.flipSource(flip);
    }

    @Override
    public void flipHorizontal(boolean flip) {
        this.mMjpegView.flipHorizontal(flip);
    }

    @Override
    public void flipVertical(boolean flip) {
        this.mMjpegView.flipVertical(flip);
    }

    @Override
    public void setRotate(float degrees) {
        this.mMjpegView.setRotate(degrees);
    }

    @Override
    public void stopPlayback() {
        this.mMjpegView.stopPlayback();
    }

    @Override
    public boolean isStreaming() {
        return this.mMjpegView.isStreaming();
    }

    @Override
    public void setResolution(int width, int height) {
        this.mMjpegView.setResolution(width, height);
    }

    @Override
    public void freeCameraMemory() {
        this.mMjpegView.freeCameraMemory();
    }

    @Override
    public void setOnFrameCapturedListener(OnFrameCapturedListener onFrameCapturedListener) {
        this.mMjpegView.setOnFrameCapturedListener(onFrameCapturedListener);
    }

    @Override
    public void setCustomBackgroundColor(int backgroundColor) {
        this.mMjpegView.setCustomBackgroundColor(backgroundColor);
    }

    @Override
    public void setFpsOverlayBackgroundColor(int overlayBackgroundColor) {
        this.mMjpegView.setFpsOverlayBackgroundColor(overlayBackgroundColor);
    }

    @Override
    public void setFpsOverlayTextColor(int overlayTextColor) {
        this.mMjpegView.setFpsOverlayTextColor(overlayTextColor);
    }

    @Override
    public SurfaceView getSurfaceView() {
        return this;
    }

    @Override
    public void resetTransparentBackground() {
        this.mMjpegView.resetTransparentBackground();
    }

    @Override
    public void setTransparentBackground() {
        this.mMjpegView.setTransparentBackground();
    }

    @Override
    public void clearStream() {
        this.mMjpegView.clearStream();
    }

    static {
        TYPE.put(0, (Object)Mjpeg.Type.DEFAULT);
        TYPE.put(1, (Object)Mjpeg.Type.NATIVE);
    }
}

