/*
 * Decompiled with CFR 0.152.
 */
package com.github.niqdev.mjpeg;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.github.niqdev.mjpeg.AbstractMjpegView;
import com.github.niqdev.mjpeg.DisplayMode;
import com.github.niqdev.mjpeg.MjpegInputStream;
import com.github.niqdev.mjpeg.MjpegInputStreamDefault;
import java.io.IOException;

public class MjpegViewDefault
extends AbstractMjpegView {
    private SurfaceHolder.Callback mSurfaceHolderCallback;
    private SurfaceView mSurfaceView;
    private static MjpegViewThread thread;
    private MjpegInputStreamDefault mIn = null;
    private boolean showFps = false;
    private boolean mRun = false;
    private boolean surfaceDone = false;
    private Paint overlayPaint;
    private int overlayTextColor;
    private int overlayBackgroundColor;
    private int ovlPos;
    private int dispWidth;
    private int dispHeight;
    private int displayMode;
    private boolean resume = false;
    private long delay;

    private void init() {
        SurfaceHolder holder = this.mSurfaceView.getHolder();
        holder.addCallback(this.mSurfaceHolderCallback);
        thread = new MjpegViewThread(holder);
        this.mSurfaceView.setFocusable(true);
        if (!this.resume) {
            this.resume = true;
            this.overlayPaint = new Paint();
            this.overlayPaint.setTextAlign(Paint.Align.LEFT);
            this.overlayPaint.setTextSize(12.0f);
            this.overlayPaint.setTypeface(Typeface.DEFAULT);
            this.overlayTextColor = -1;
            this.overlayBackgroundColor = -16777216;
            this.ovlPos = 6;
            this.displayMode = 1;
            this.dispWidth = this.mSurfaceView.getWidth();
            this.dispHeight = this.mSurfaceView.getHeight();
        }
    }

    void _startPlayback() {
        if (this.mIn != null) {
            this.mRun = true;
            thread.start();
        }
    }

    void _resumePlayback() {
        this.mRun = true;
        this.init();
        thread.start();
    }

    void _stopPlayback() {
        this.mRun = false;
        boolean retry = true;
        while (retry) {
            try {
                thread.join();
                retry = false;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void _surfaceChanged(SurfaceHolder holder, int f, int w, int h) {
        thread.setSurfaceSize(w, h);
    }

    void _surfaceDestroyed(SurfaceHolder holder) {
        this.surfaceDone = false;
        this._stopPlayback();
        if (thread != null) {
            thread = null;
        }
    }

    MjpegViewDefault(SurfaceView surfaceView, SurfaceHolder.Callback callback) {
        this.mSurfaceView = surfaceView;
        this.mSurfaceHolderCallback = callback;
        this.init();
    }

    void _surfaceCreated(SurfaceHolder holder) {
        this.surfaceDone = true;
    }

    void _showFps(boolean b) {
        this.showFps = b;
    }

    void _setSource(MjpegInputStreamDefault source) {
        this.mIn = source;
        this._startPlayback();
    }

    void _setOverlayPaint(Paint p) {
        this.overlayPaint = p;
    }

    void _setOverlayTextColor(int c) {
        this.overlayTextColor = c;
    }

    void _setOverlayBackgroundColor(int c) {
        this.overlayBackgroundColor = c;
    }

    void _setOverlayPosition(int p) {
        this.ovlPos = p;
    }

    void _setDisplayMode(int s) {
        this.displayMode = s;
    }

    @Override
    public void onSurfaceCreated(SurfaceHolder holder) {
        this._surfaceCreated(holder);
    }

    @Override
    public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        this._surfaceChanged(holder, format, width, height);
    }

    @Override
    public void onSurfaceDestroyed(SurfaceHolder holder) {
        this._surfaceDestroyed(holder);
    }

    @Override
    public void setSource(MjpegInputStream stream) {
        if (!(stream instanceof MjpegInputStreamDefault)) {
            throw new IllegalArgumentException("stream must be an instance of MjpegInputStreamDefault");
        }
        this._setSource((MjpegInputStreamDefault)stream);
    }

    @Override
    public void setDisplayMode(DisplayMode mode) {
        this._setDisplayMode(mode.getValue());
    }

    @Override
    public void showFps(boolean show) {
        this._showFps(show);
    }

    @Override
    public void stopPlayback() {
        this._stopPlayback();
    }

    @Override
    public boolean isStreaming() {
        return this.mRun;
    }

    @Override
    public void setResolution(int width, int height) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public void freeCameraMemory() {
        throw new UnsupportedOperationException("not implemented");
    }

    class MjpegViewThread
    extends Thread {
        private SurfaceHolder mSurfaceHolder;
        private int frameCounter = 0;
        private long start;
        private Bitmap ovl;

        MjpegViewThread(SurfaceHolder surfaceHolder) {
            this.mSurfaceHolder = surfaceHolder;
        }

        private Rect destRect(int bmw, int bmh) {
            if (MjpegViewDefault.this.displayMode == 1) {
                int tempx = MjpegViewDefault.this.dispWidth / 2 - bmw / 2;
                int tempy = MjpegViewDefault.this.dispHeight / 2 - bmh / 2;
                return new Rect(tempx, tempy, bmw + tempx, bmh + tempy);
            }
            if (MjpegViewDefault.this.displayMode == 4) {
                float bmasp = (float)bmw / (float)bmh;
                bmw = MjpegViewDefault.this.dispWidth;
                bmh = (int)((float)MjpegViewDefault.this.dispWidth / bmasp);
                if (bmh > MjpegViewDefault.this.dispHeight) {
                    bmh = MjpegViewDefault.this.dispHeight;
                    bmw = (int)((float)MjpegViewDefault.this.dispHeight * bmasp);
                }
                int tempx = MjpegViewDefault.this.dispWidth / 2 - bmw / 2;
                int tempy = MjpegViewDefault.this.dispHeight / 2 - bmh / 2;
                return new Rect(tempx, tempy, bmw + tempx, bmh + tempy);
            }
            if (MjpegViewDefault.this.displayMode == 8) {
                return new Rect(0, 0, MjpegViewDefault.this.dispWidth, MjpegViewDefault.this.dispHeight);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSurfaceSize(int width, int height) {
            SurfaceHolder surfaceHolder = this.mSurfaceHolder;
            synchronized (surfaceHolder) {
                MjpegViewDefault.this.dispWidth = width;
                MjpegViewDefault.this.dispHeight = height;
            }
        }

        private Bitmap makeFpsOverlay(Paint p, String text) {
            Rect b = new Rect();
            p.getTextBounds(text, 0, text.length(), b);
            int bwidth = b.width() + 2;
            int bheight = b.height() + 2;
            Bitmap bm = Bitmap.createBitmap((int)bwidth, (int)bheight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(bm);
            p.setColor(MjpegViewDefault.this.overlayBackgroundColor);
            c.drawRect(0.0f, 0.0f, (float)bwidth, (float)bheight, p);
            p.setColor(MjpegViewDefault.this.overlayTextColor);
            c.drawText(text, (float)(-b.left + 1), (float)(bheight / 2) - (p.ascent() + p.descent()) / 2.0f + 1.0f, p);
            return bm;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.start = System.currentTimeMillis();
            PorterDuffXfermode mode = new PorterDuffXfermode(PorterDuff.Mode.DST_OVER);
            Canvas c = null;
            Paint p = new Paint();
            String fps = "";
            while (MjpegViewDefault.this.mRun) {
                if (!MjpegViewDefault.this.surfaceDone) continue;
                try {
                    c = this.mSurfaceHolder.lockCanvas();
                    SurfaceHolder surfaceHolder = this.mSurfaceHolder;
                    synchronized (surfaceHolder) {
                        try {
                            Bitmap bm = MjpegViewDefault.this.mIn.readMjpegFrame();
                            Rect destRect = this.destRect(bm.getWidth(), bm.getHeight());
                            c.drawColor(-16777216);
                            c.drawBitmap(bm, null, destRect, p);
                            if (MjpegViewDefault.this.showFps) {
                                p.setXfermode((Xfermode)mode);
                                if (this.ovl != null) {
                                    int height = (MjpegViewDefault.this.ovlPos & 1) == 1 ? destRect.top : destRect.bottom - this.ovl.getHeight();
                                    int width = (MjpegViewDefault.this.ovlPos & 8) == 8 ? destRect.left : destRect.right - this.ovl.getWidth();
                                    c.drawBitmap(this.ovl, (float)width, (float)height, null);
                                }
                                p.setXfermode(null);
                                ++this.frameCounter;
                                if (System.currentTimeMillis() - this.start >= 1000L) {
                                    fps = String.valueOf(this.frameCounter) + "fps";
                                    this.frameCounter = 0;
                                    this.start = System.currentTimeMillis();
                                    this.ovl = this.makeFpsOverlay(MjpegViewDefault.this.overlayPaint, fps);
                                }
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    if (c == null) continue;
                    this.mSurfaceHolder.unlockCanvasAndPost(c);
                }
            }
        }
    }
}

