/*
 * Decompiled with CFR 0.152.
 */
package com.github.nikartm.support;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.github.nikartm.support.R;
import com.github.nikartm.support.StripedDrawable;
import com.github.nikartm.support.constant.Constants;

class AttributeController {
    private StripedDrawable stripedDrawable = new StripedDrawable();

    public AttributeController(Context context, AttributeSet attrs) {
        this.initAttrs(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.StripedProcessButton);
        try {
            float stripeWidth = typedArray.getDimension(R.styleable.StripedProcessButton_spb_stripeWidth, 36.0f);
            float stripeAlpha = typedArray.getFloat(R.styleable.StripedProcessButton_spb_stripeAlpha, 0.3f);
            int stripeTilt = typedArray.getInt(R.styleable.StripedProcessButton_spb_stripeTilt, 25);
            int stripeDuration = typedArray.getInt(R.styleable.StripedProcessButton_spb_stripeDuration, 250);
            int background = typedArray.getColor(R.styleable.StripedProcessButton_spb_background, Constants.DEF_BACKGROUND);
            int mainStripeColor = typedArray.getColor(R.styleable.StripedProcessButton_spb_mainStripColor, Constants.DEF_MAIN_STRIPE);
            int subStripeColor = typedArray.getColor(R.styleable.StripedProcessButton_spb_subStripeColor, Constants.DEF_SUB_STRIPE);
            float cornerRadius = typedArray.getFloat(R.styleable.StripedProcessButton_spb_cornerRadius, 0.0f);
            boolean stripeRevert = typedArray.getBoolean(R.styleable.StripedProcessButton_spb_stripeRevert, false);
            boolean showStripes = typedArray.getBoolean(R.styleable.StripedProcessButton_spb_showStripes, false);
            boolean stripeGradient = typedArray.getBoolean(R.styleable.StripedProcessButton_spb_stripeGradient, true);
            String loadingText = typedArray.getString(R.styleable.StripedProcessButton_spb_loadingText);
            this.stripedDrawable.setStripeWidth(stripeWidth).setStripeAlpha(stripeAlpha).setTilt(stripeTilt).setStripeDuration(stripeDuration).setColorBack(background).setColorMain(mainStripeColor).setColorSub(subStripeColor).setCornerRadius(cornerRadius).setStripeRevert(stripeRevert).setShowStripes(showStripes).setStripeGradient(stripeGradient).setLoadingText(loadingText);
        }
        finally {
            typedArray.recycle();
        }
    }

    public StripedDrawable getStripedDrawable() {
        return this.stripedDrawable;
    }
}

