/*
 * Decompiled with CFR 0.152.
 */
package com.github.nikartm.support;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Animatable;
import android.support.v7.widget.AppCompatButton;
import android.util.AttributeSet;
import android.view.View;
import com.github.nikartm.support.AnimatedStripedDrawable;
import com.github.nikartm.support.AttributeController;
import com.github.nikartm.support.Util;

public class StripedProcessButton
extends AppCompatButton
implements Animatable {
    private AnimatedStripedDrawable stripedDrawable;
    private State state = State.STOP;
    private long startAnimDuration = -1L;
    private long stopAnimDuration = -1L;
    private boolean buttonAnimation = true;
    private String defaultText;
    private String loadingText;

    public StripedProcessButton(Context context) {
        super(context);
        this.initAttrs(null);
    }

    public StripedProcessButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
    }

    public StripedProcessButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
    }

    private void initAttrs(AttributeSet attrs) {
        AttributeController attrController = new AttributeController(this.getContext(), attrs);
        this.stripedDrawable = attrController.getStripedDrawable();
        this.loadingText = attrController.getLoadingText();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.defaultText = this.getText() != null ? this.getText().toString() : "";
        this.launchAnimationWithDelay();
    }

    private void launchAnimationWithDelay() {
        switch (this.state) {
            case START: {
                this.start();
                break;
            }
            case STOP: {
                this.stop();
                break;
            }
        }
    }

    protected void onDraw(Canvas canvas) {
        this.setBackground(this.stripedDrawable);
        this.setEnabled(!this.isRunning());
        super.onDraw(canvas);
    }

    public void start() {
        this.state = State.START;
        if (this.isRunning() || !this.isAttachedToWindow()) {
            return;
        }
        this.setEnabled(this.isRunning());
        this.stripedDrawable.start();
        this.animateButton(this.isRunning());
    }

    public void stop() {
        this.state = State.STOP;
        if (!this.isRunning() || !this.isAttachedToWindow()) {
            return;
        }
        this.setEnabled(this.isRunning());
        this.stripedDrawable.stop();
        this.animateButton(this.isRunning());
    }

    public boolean isRunning() {
        return this.isAttachedToWindow() && this.stripedDrawable.isRunning();
    }

    private void animateButton(boolean start) {
        if (this.isButtonAnimation()) {
            long duration = start ? (this.startAnimDuration == -1L ? 700L : this.startAnimDuration) : (this.stopAnimDuration == -1L ? 300L : this.stopAnimDuration);
            this.setCurrentText(start);
            Util.Animation.animateView((View)this, start, duration);
        }
    }

    private void setCurrentText(boolean start) {
        String currentText = start ? (this.loadingText == null ? this.defaultText : this.loadingText) : this.defaultText;
        this.setText(currentText);
    }

    public AnimatedStripedDrawable adjustButton() {
        return this.stripedDrawable;
    }

    public long getStartAnimDuration() {
        return this.startAnimDuration;
    }

    public StripedProcessButton setStartAnimDuration(long startAnimDuration) {
        this.startAnimDuration = startAnimDuration;
        this.invalidate();
        return this;
    }

    public long getStopAnimDuration() {
        return this.stopAnimDuration;
    }

    public StripedProcessButton setStopAnimDuration(long stopAnimDuration) {
        this.stopAnimDuration = stopAnimDuration;
        this.invalidate();
        return this;
    }

    public String getLoadingText() {
        return this.loadingText;
    }

    public StripedProcessButton setLoadingText(String loadingText) {
        this.loadingText = loadingText;
        this.invalidate();
        return this;
    }

    public boolean isButtonAnimation() {
        return this.buttonAnimation;
    }

    public StripedProcessButton setButtonAnimation(boolean buttonAnimation) {
        this.buttonAnimation = buttonAnimation;
        this.invalidate();
        return this;
    }

    private static enum State {
        START,
        STOP;

    }
}

