/*
 * Decompiled with CFR 0.152.
 */
package ru.nikartm.support;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.view.View;
import ru.nikartm.support.model.Badge;

public class BadgeDrawer {
    private View view;
    private Badge badge;
    private Paint paint;
    private float dx;
    private float dy;

    public BadgeDrawer(View view, Badge badge) {
        this.view = view;
        this.badge = badge;
    }

    public void draw(Canvas canvas) {
        if (this.badge.isVisible() && this.badge.getValue() > 0) {
            this.initPaint();
            float pivotX = this.view.getPivotX();
            float pivotY = this.view.getPivotY();
            int viewHeight = this.view.getMeasuredHeight();
            int viewWidth = this.view.getMeasuredWidth();
            this.badge.setTextWidth(this.getTextWidth());
            this.computeRadius();
            this.dx = pivotX + (float)(viewWidth / 2) - this.badge.getRadius();
            this.dy = pivotY - (float)(viewHeight / 2) + this.badge.getRadius();
            this.drawBadge(canvas, pivotX, pivotY, viewHeight, viewWidth);
            this.drawText(canvas);
        }
    }

    private void initPaint() {
        if (this.paint == null) {
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            Typeface typeface = Typeface.create((Typeface)this.badge.getBadgeTextFont(), (int)this.badge.getTextStyle());
            this.paint.setTypeface(typeface);
            this.paint.setTextSize(this.badge.getBadgeTextSize());
        }
    }

    private void drawBadge(Canvas canvas, float pivotX, float pivotY, int viewHeight, int viewWidth) {
        this.paint.setColor(this.badge.getBadgeColor());
        if (this.badge.getBackgroundDrawable() != null) {
            this.drawCustomBadgeBackground(canvas, pivotX, pivotY, viewHeight, viewWidth);
        } else {
            canvas.drawCircle(this.dx, this.dy, this.badge.getRadius(), this.paint);
        }
    }

    private void drawCustomBadgeBackground(Canvas canvas, float pivotX, float pivotY, int viewHeight, int viewWidth) {
        this.dy = pivotY - (float)(viewHeight / 2) + this.getBadgeHeight() / 2.0f;
        int valueHeight = (int)this.getBadgeHeight();
        int valueWidth = (int)this.getBadgeWidth();
        if (this.badge.isFixedRadius()) {
            int maxRadius;
            if (valueWidth > valueHeight) {
                this.dy = pivotY - (float)(viewHeight / 2) + this.getBadgeWidth() / 2.0f;
                this.dx = pivotX + (float)(viewWidth / 2) - this.getBadgeWidth() / 2.0f;
            } else {
                this.dy = pivotY - (float)(viewHeight / 2) + this.getBadgeHeight() / 2.0f;
                this.dx = pivotX + (float)(viewWidth / 2) - this.getBadgeHeight() / 2.0f;
            }
            valueWidth = maxRadius = Math.max(valueWidth, valueHeight);
            valueHeight = maxRadius;
        } else if (this.badge.isRoundBadge() && valueWidth < valueHeight) {
            this.dx = pivotX + (float)(viewWidth / 2) - this.getBadgeHeight() / 2.0f;
            valueWidth = valueHeight;
        }
        if (this.badge.getBackgroundDrawable() != null) {
            this.badge.getBackgroundDrawable().setBounds(0, 0, valueWidth, valueHeight);
            canvas.save();
            canvas.translate(this.dx - (float)(valueWidth / 2), this.dy - (float)(valueHeight / 2));
            this.badge.getBackgroundDrawable().draw(canvas);
            canvas.restore();
        }
    }

    private void drawText(Canvas canvas) {
        this.paint.setColor(this.badge.getBadgeTextColor());
        if (this.badge.isLimitValue() && this.badge.getValue() > this.badge.getMaxValue()) {
            canvas.drawText(String.valueOf(this.badge.getMaxValue()).concat("+"), this.dx - this.badge.getTextWidth() / 2.0f, this.dy + this.badge.getBadgeTextSize() / 3.0f, this.paint);
        } else {
            canvas.drawText(String.valueOf(this.badge.getValue()), this.dx - this.badge.getTextWidth() / 2.0f, this.dy + this.badge.getBadgeTextSize() / 3.0f, this.paint);
        }
    }

    private float getBadgeHeight() {
        return this.badge.getBadgeTextSize() + this.badge.getPadding() * 2.0f;
    }

    private float getBadgeWidth() {
        float width = this.badge.getBackgroundDrawable() != null && this.badge.getValue() > 9 && this.badge.isOvalAfterFirst() && !this.badge.isFixedRadius() ? this.badge.getTextWidth() + this.badge.getPadding() * 4.0f : this.badge.getTextWidth() + this.badge.getPadding() * 2.0f;
        return width;
    }

    private float getTextWidth() {
        float textWidth = this.badge.isLimitValue() && this.badge.getValue() > this.badge.getMaxValue() ? this.paint.measureText(String.valueOf(this.badge.getMaxValue()).concat("+")) : this.paint.measureText(String.valueOf(this.badge.getValue()));
        return textWidth;
    }

    private void computeRadius() {
        if (this.badge.getFixedRadiusSize() != -1.0f) {
            this.badge.setRadius(this.badge.getFixedRadiusSize());
        } else {
            this.badge.setRadius(this.getBadgeWidth() / 2.0f);
        }
    }
}

