/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner.validation;

import com.github.mvp4g.mvp4g2.core.ui.AbstractHandler;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class HandlerAnnotationValidator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnvironment;

    private HandlerAnnotationValidator() {
    }

    private HandlerAnnotationValidator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.roundEnvironment = builder.roundEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate(Element element) throws ProcessorException {
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            if (!typeElement.getKind().isClass()) {
                throw new ProcessorException(typeElement.getSimpleName().toString() + ": @Handler can only be used with a class!");
            }
            if (!this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(AbstractHandler.class.getCanonicalName()).asType())) {
                throw new ProcessorException(typeElement.getSimpleName().toString() + ": @Handler must extend AbstractHandler.class!");
            }
            if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                throw new ProcessorException(typeElement.getSimpleName().toString() + ": @Handler can not be ABSTRACT");
            }
        } else {
            throw new ProcessorException("@Handler can only be used on a type (class)");
        }
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;
        RoundEnvironment roundEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder roundEnvironment(RoundEnvironment roundEnvironment) {
            this.roundEnvironment = roundEnvironment;
            return this;
        }

        public HandlerAnnotationValidator build() {
            return new HandlerAnnotationValidator(this);
        }
    }
}

