/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner.validation;

import com.github.mvp4g.mvp4g2.core.eventbus.IsEventBus;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.EventBus;
import com.github.mvp4g.mvp4g2.core.eventbus.annotation.Start;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class EventBusAnnotationValidator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnvironment;

    private EventBusAnnotationValidator() {
    }

    private EventBusAnnotationValidator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.roundEnvironment = builder.roundEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validate() throws ProcessorException {
        Set<? extends Element> elementsWithEventBusAnnotation = this.roundEnvironment.getElementsAnnotatedWith(EventBus.class);
        if (elementsWithEventBusAnnotation.size() == 0) {
            throw new ProcessorException("Mvp4g2Processor: Missing Mvp4g EventBus interface");
        }
        if (elementsWithEventBusAnnotation.size() > 1) {
            throw new ProcessorException("Mvp4g2Processor: There should be at least only one interface, that is annotated with @EventBus");
        }
    }

    public void validate(Element element) throws ProcessorException {
        Set<? extends Element> elementsWithEventBusAnnotation = this.roundEnvironment.getElementsAnnotatedWith(EventBus.class);
        if (element instanceof TypeElement) {
            ExecutableElement executableElement;
            TypeElement typeElement = (TypeElement)element;
            if (!typeElement.getKind().isInterface()) {
                throw new ProcessorException("Mvp4g2Processor: @Eventbus can only be used with an interface");
            }
            if (!this.processorUtils.extendsClassOrInterface(this.processingEnvironment.getTypeUtils(), typeElement.asType(), this.processingEnvironment.getElementUtils().getTypeElement(IsEventBus.class.getCanonicalName()).asType())) {
                throw new ProcessorException(typeElement.getSimpleName().toString() + ": @Eventbus must extend IsEventBus.class!");
            }
            List<Element> elementsAnnotatedWithStart = this.processorUtils.getMethodFromTypeElementAnnotatedWith(this.processingEnvironment, typeElement, Start.class);
            if (elementsAnnotatedWithStart.size() > 1) {
                throw new ProcessorException("Mvp4g2Processor: @Start-annotation can only be used a single time in a eventbus interface");
            }
            if (elementsAnnotatedWithStart.size() == 1 && (executableElement = (ExecutableElement)elementsAnnotatedWithStart.get(0)).getParameters().size() > 0) {
                throw new ProcessorException("Mvp4g2Processor: @Start-annotation can only be used on zero argument methods");
            }
        } else {
            throw new ProcessorException("Mvp4g2Processor: @Eventbus can only be used on a type (interface)");
        }
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;
        RoundEnvironment roundEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder roundEnvironment(RoundEnvironment roundEnvironment) {
            this.roundEnvironment = roundEnvironment;
            return this;
        }

        public EventBusAnnotationValidator build() {
            return new EventBusAnnotationValidator(this);
        }
    }
}

