/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner;

import com.github.mvp4g.mvp4g2.core.history.annotation.History;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.HistoryMetaModel;
import com.github.mvp4g.mvp4g2.processor.scanner.validation.HistoryAnnotationValidator;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class HistoryAnnotationScanner {
    private static final String HISTORY_PROPERTIES = "history.properties";
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;

    private HistoryAnnotationScanner(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public HistoryMetaModel scan(RoundEnvironment roundEnvironment) throws ProcessorException {
        HistoryMetaModel model = this.restore();
        if (!roundEnvironment.getElementsAnnotatedWith(History.class).isEmpty()) {
            HistoryAnnotationValidator validator = HistoryAnnotationValidator.builder().roundEnvironment(roundEnvironment).processingEnvironment(this.processingEnvironment).build();
            for (Element element : roundEnvironment.getElementsAnnotatedWith(History.class)) {
                validator.validate(element);
                TypeElement typeElement = (TypeElement)element;
                History historyAnnotation = typeElement.getAnnotation(History.class);
                validator.validate(element);
                model.add(typeElement.getQualifiedName().toString(), historyAnnotation.type().toString());
            }
            this.processorUtils.store(model, this.createRelativeFileName());
        }
        return model;
    }

    private HistoryMetaModel restore() {
        Properties props = new Properties();
        try {
            FileObject resource = this.processingEnvironment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.createRelativeFileName());
            props.load(resource.openInputStream());
            return new HistoryMetaModel(props);
        }
        catch (IOException iOException) {
            return new HistoryMetaModel();
        }
    }

    private String createRelativeFileName() {
        return "META-INF/mvp4g2/history.properties";
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public HistoryAnnotationScanner build() {
            return new HistoryAnnotationScanner(this);
        }
    }
}

