/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.scanner;

import com.github.mvp4g.mvp4g2.core.application.annotation.Application;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.ApplicationMetaModel;
import com.github.mvp4g.mvp4g2.processor.scanner.validation.ApplicationAnnotationValidator;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class ApplicationAnnotationScanner {
    private static final String APPLICATION_PROPERTIES = "application.properties";
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private RoundEnvironment roundEnvironment;

    private ApplicationAnnotationScanner(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.roundEnvironment = builder.roundEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public ApplicationMetaModel scan(RoundEnvironment roundEnvironment) throws ProcessorException {
        ApplicationMetaModel model = this.restore();
        if (!roundEnvironment.getElementsAnnotatedWith(Application.class).isEmpty()) {
            ApplicationAnnotationValidator validator = ApplicationAnnotationValidator.builder().roundEnvironment(roundEnvironment).processingEnvironment(this.processingEnvironment).build();
            validator.validate();
            Optional optionalElement = this.roundEnvironment.getElementsAnnotatedWith(Application.class).stream().findFirst();
            if (optionalElement.isPresent()) {
                Element applicationAnnotationElement = (Element)optionalElement.get();
                validator.validate(applicationAnnotationElement);
                Application applicationAnnotation = applicationAnnotationElement.getAnnotation(Application.class);
                if (!Objects.isNull(applicationAnnotation)) {
                    TypeElement eventBusTypeElement = this.getEventBusTypeElement(applicationAnnotation);
                    TypeElement applicationLoaderTypeElement = this.getApplicationLoaderTypeElement(applicationAnnotation);
                    model = new ApplicationMetaModel(applicationAnnotationElement.toString(), Objects.isNull(eventBusTypeElement) ? "" : eventBusTypeElement.toString(), Objects.isNull(applicationLoaderTypeElement) ? "" : applicationLoaderTypeElement.toString(), String.valueOf(applicationAnnotation.historyOnStart()), String.valueOf(applicationAnnotation.encodeToken()));
                    this.processorUtils.store(model, this.createRelativeFileName());
                }
            }
        }
        return model;
    }

    private ApplicationMetaModel restore() {
        Properties props = new Properties();
        try {
            FileObject resource = this.processingEnvironment.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", this.createRelativeFileName());
            props.load(resource.openInputStream());
            return new ApplicationMetaModel(props);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private TypeElement getEventBusTypeElement(Application applicationAnnotation) {
        try {
            applicationAnnotation.eventBus();
        }
        catch (MirroredTypeException exception) {
            return (TypeElement)this.processingEnvironment.getTypeUtils().asElement(exception.getTypeMirror());
        }
        return null;
    }

    private TypeElement getApplicationLoaderTypeElement(Application applicationAnnotation) {
        try {
            applicationAnnotation.loader();
        }
        catch (MirroredTypeException exception) {
            return (TypeElement)this.processingEnvironment.getTypeUtils().asElement(exception.getTypeMirror());
        }
        return null;
    }

    private String createRelativeFileName() {
        return "META-INF/mvp4g2/application.properties";
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;
        RoundEnvironment roundEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder roundEnvironment(RoundEnvironment roundEnvironment) {
            this.roundEnvironment = roundEnvironment;
            return this;
        }

        public ApplicationAnnotationScanner build() {
            return new ApplicationAnnotationScanner(this);
        }
    }
}

