/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.model.intern;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.util.Objects;

public class ClassNameModel {
    private String className;

    public ClassNameModel(String className) {
        this.className = Objects.requireNonNull(className);
    }

    public String getClassName() {
        return this.className;
    }

    public TypeName getTypeName() {
        switch (this.className) {
            case "void": {
                return TypeName.VOID;
            }
            case "boolean": {
                return TypeName.BOOLEAN;
            }
            case "byte": {
                return TypeName.BYTE;
            }
            case "short": {
                return TypeName.SHORT;
            }
            case "int": {
                return TypeName.INT;
            }
            case "long": {
                return TypeName.LONG;
            }
            case "char": {
                return TypeName.CHAR;
            }
            case "float": {
                return TypeName.FLOAT;
            }
            case "double": {
                return TypeName.DOUBLE;
            }
            case "Object": {
                return TypeName.OBJECT;
            }
            case "Void": {
                return ClassName.get((String)"java.lang", (String)"Void", (String[])new String[0]);
            }
            case "Boolean": {
                return ClassName.get((String)"java.lang", (String)"Boolean", (String[])new String[0]);
            }
            case "Byte": {
                return ClassName.get((String)"java.lang", (String)"Byte", (String[])new String[0]);
            }
            case "Short": {
                return ClassName.get((String)"java.lang", (String)"Short", (String[])new String[0]);
            }
            case "Integer": {
                return ClassName.get((String)"java.lang", (String)"Integer", (String[])new String[0]);
            }
            case "Long": {
                return ClassName.get((String)"java.lang", (String)"Long", (String[])new String[0]);
            }
            case "Character": {
                return ClassName.get((String)"java.lang", (String)"Character", (String[])new String[0]);
            }
            case "Float": {
                return ClassName.get((String)"java.lang", (String)"Float", (String[])new String[0]);
            }
            case "Double": {
                return ClassName.get((String)"java.lang", (String)"Double", (String[])new String[0]);
            }
        }
        return ClassName.get((String)this.getPackage(), (String)this.getSimpleName(), (String[])new String[0]);
    }

    public String getPackage() {
        return this.className.contains(".") ? this.className.substring(0, this.className.lastIndexOf(".")) : "";
    }

    public String getSimpleName() {
        return this.className.contains(".") ? this.className.substring(this.className.lastIndexOf(".") + 1) : this.className;
    }

    public String normalized() {
        return this.className.replace(".", "_");
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassNameModel)) {
            return false;
        }
        ClassNameModel that = (ClassNameModel)o;
        return Objects.equals(this.className, that.className);
    }
}

