/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.model;

import com.github.mvp4g.mvp4g2.processor.model.EventMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.IsMetaModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class EventBusMetaModel
implements IsMetaModel {
    private static final String KEY_EVENTBUS = "eventBus";
    private static final String KEY_SHELL = "shell";
    private static final String KEY_EVENTS = "events";
    private static final String KEY_HAS_DEBUG_ANNOTATION = "hasDebugAnnotation";
    private static final String KEY_DEBUG_LOG_LEVEL = "debugLogLevel";
    private static final String KEY_DEBUG_LOGGER = "debugLogger";
    private static final String KEY_HAS_FILTERS_ANNOTATION = "hasFiltersAnnotation";
    private static final String KEY_FILTERS = "filters";
    private ClassNameModel eventBus;
    private ClassNameModel shell;
    private List<String> events = new ArrayList<String>();
    private String hasDebugAnnotation;
    private String debugLogLevel;
    private ClassNameModel debugLogger;
    private String hasFiltersAnnotation;
    private List<ClassNameModel> filters = new ArrayList<ClassNameModel>();
    private Map<String, EventMetaModel> eventMetaModels = new HashMap<String, EventMetaModel>();

    public EventBusMetaModel(Properties properties) {
        this.eventBus = new ClassNameModel(properties.getProperty(KEY_EVENTBUS));
        this.shell = new ClassNameModel(properties.getProperty(KEY_SHELL));
        this.events = Arrays.stream(properties.getProperty(KEY_EVENTS).split("\\s*,\\s*")).collect(Collectors.toList());
        this.hasDebugAnnotation = properties.getProperty(KEY_HAS_DEBUG_ANNOTATION);
        this.debugLogger = new ClassNameModel(properties.getProperty(KEY_DEBUG_LOGGER));
        this.debugLogLevel = properties.getProperty(KEY_DEBUG_LOG_LEVEL);
        this.hasFiltersAnnotation = properties.getProperty(KEY_HAS_FILTERS_ANNOTATION);
        this.filters = this.isEmptyOrNull(properties.getProperty(KEY_FILTERS)) ? new ArrayList<ClassNameModel>() : Arrays.stream(properties.getProperty(KEY_FILTERS).split("\\s*,\\s*")).map(ClassNameModel::new).collect(Collectors.toList());
    }

    public EventBusMetaModel(String eventBus, String shell) {
        this.eventBus = new ClassNameModel(eventBus);
        this.shell = new ClassNameModel(shell);
    }

    public void add(EventMetaModel eventMetaModel) {
        this.eventMetaModels.put(eventMetaModel.getEventInternalName(), eventMetaModel);
        if (!this.events.contains(eventMetaModel.getEventInternalName())) {
            this.events.add(eventMetaModel.getEventInternalName());
        }
    }

    private boolean isEmptyOrNull(String value) {
        return value == null || value.isEmpty();
    }

    public Collection<String> getEventMetaModelKeys() {
        return this.eventMetaModels.keySet();
    }

    public Collection<EventMetaModel> getEventMetaModels() {
        return this.eventMetaModels.values();
    }

    public EventMetaModel getEventMetaModel(String eventInternalName) {
        return this.eventMetaModels.get(eventInternalName);
    }

    public ClassNameModel getEventBus() {
        return this.eventBus;
    }

    public ClassNameModel getShell() {
        return this.shell;
    }

    public String getDebugLogLevel() {
        return this.debugLogLevel;
    }

    public void setDebugLogLevel(String debugLogLevel) {
        this.debugLogLevel = debugLogLevel;
    }

    public ClassNameModel getDebugLogger() {
        return this.debugLogger;
    }

    public void setDebugLogger(String debugLogger) {
        this.debugLogger = new ClassNameModel(debugLogger);
    }

    public boolean hasDebugAnnotation() {
        return "true".equals(this.hasDebugAnnotation);
    }

    public void setHasDebugAnnotation(String hasDebugAnnotation) {
        this.hasDebugAnnotation = hasDebugAnnotation;
    }

    public boolean hasFiltersAnnotation() {
        return "true".equals(this.hasFiltersAnnotation);
    }

    public void setHasFiltersAnnotation(String hasFiltersAnnotation) {
        this.hasFiltersAnnotation = hasFiltersAnnotation;
    }

    public List<ClassNameModel> getFilters() {
        return this.filters;
    }

    public void setFilters(List<String> filters) {
        filters.stream().forEach(s -> this.filters.add(new ClassNameModel((String)s)));
    }

    public List<String> getEvents() {
        return this.events;
    }

    @Override
    public Properties createPropertes() {
        Properties properties = new Properties();
        properties.setProperty(KEY_EVENTBUS, this.eventBus.getClassName());
        properties.setProperty(KEY_SHELL, this.shell.getClassName());
        properties.setProperty(KEY_EVENTS, String.join((CharSequence)",", String.join((CharSequence)",", this.eventMetaModels.keySet().stream().collect(Collectors.toCollection(ArrayList::new)))));
        properties.setProperty(KEY_HAS_DEBUG_ANNOTATION, this.hasDebugAnnotation);
        properties.setProperty(KEY_DEBUG_LOGGER, this.debugLogger.getClassName());
        properties.setProperty(KEY_DEBUG_LOG_LEVEL, this.debugLogLevel);
        properties.setProperty(KEY_HAS_FILTERS_ANNOTATION, this.hasFiltersAnnotation);
        properties.setProperty(KEY_FILTERS, String.join((CharSequence)",", this.filters.stream().map(c -> c.getClassName()).collect(Collectors.toCollection(ArrayList::new))));
        return properties;
    }
}

