/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.core.internal.ui.AbstractHandlerMetaData;
import com.github.mvp4g.mvp4g2.core.internal.ui.HandlerMetaData;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.HandlerMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class HandlerGenerator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;

    private HandlerGenerator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate(HandlerMetaModel metaModel) throws ProcessorException {
        ClassName eventHandlerMetaDataClassName = ClassName.get(HandlerMetaData.class);
        ClassName eventHandlerMetaDataKindClassName = ClassName.get(AbstractHandlerMetaData.Kind.class);
        for (String eventHandler : metaModel.getHandlerKeys()) {
            if (!this.processorUtils.doesExist(new ClassNameModel(eventHandler))) continue;
            HandlerMetaModel.HandlerData data = metaModel.getHandlerData(eventHandler);
            String className = this.processorUtils.createFullClassName(data.getHandler().getPackage(), data.getHandler().getSimpleName() + "MetaData");
            TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)this.processorUtils.setFirstCharacterToUpperCase(className)).superclass((TypeName)ParameterizedTypeName.get((ClassName)eventHandlerMetaDataClassName, (TypeName[])new TypeName[]{data.getHandler().getTypeName()})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            MethodSpec.Builder constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($S, $T.EVENT_HANDLER, new $T())", new Object[]{data.getHandler().getClassName(), eventHandlerMetaDataKindClassName, data.getHandler().getTypeName()});
            typeSpec.addMethod(constructor.build());
            JavaFile javaFile = JavaFile.builder((String)data.getHandler().getPackage(), (TypeSpec)typeSpec.build()).build();
            try {
                javaFile.writeTo(this.processingEnvironment.getFiler());
            }
            catch (IOException e) {
                throw new ProcessorException("Unable to write generated file: >>" + data.getHandler().getSimpleName() + "MetaData" + "<< -> exception: " + e.getMessage());
            }
        }
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public HandlerGenerator build() {
            return new HandlerGenerator(this);
        }
    }
}

