/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.HandlerMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.PresenterMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.intern.ClassNameModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class HandlerAndPresenterRegristrationGenerator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private TypeSpec.Builder typeSpec;
    private EventBusMetaModel eventBusMetaModel;
    private HandlerMetaModel handlerMetaModel;
    private PresenterMetaModel presenterMetaModel;

    private HandlerAndPresenterRegristrationGenerator() {
    }

    private HandlerAndPresenterRegristrationGenerator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.typeSpec = builder.typeSpec;
        this.eventBusMetaModel = builder.eventBusMetaModel;
        this.handlerMetaModel = builder.handlerMetaModel;
        this.presenterMetaModel = builder.presenterMetaModel;
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate() throws ProcessorException {
        MethodSpec.Builder loadEventHandlerMethod = MethodSpec.methodBuilder((String)"loadEventHandlerMetaData").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED});
        List<ClassNameModel> listOfEventHandlersToCreate = this.createListOfEventHandlersToCreate();
        listOfEventHandlersToCreate.forEach(handlerClassName -> this.addHandlerToMetaList(loadEventHandlerMethod, (ClassNameModel)handlerClassName));
        loadEventHandlerMethod.addComment("", new Object[0]);
        loadEventHandlerMethod.addComment("===> add the handler to the handler list of the EventMetaData-class", new Object[0]);
        this.handlerMetaModel.getHandlerKeys().stream().filter(s -> !listOfEventHandlersToCreate.contains(s)).map(s -> this.handlerMetaModel.getHandlerData((String)s)).forEach(handlerData -> handlerData.getHandledEvents().stream().filter(event -> event != null && event.trim().length() > 0).map(handledEvent -> this.processorUtils.createEventNameFromHandlingMethod((String)handledEvent)).map(event -> this.eventBusMetaModel.getEventMetaModel((String)event)).filter(Objects::nonNull).filter(eventMetaModel -> !eventMetaModel.getHandlers().contains(handlerData.getHandler())).forEach(eventMetaModel -> loadEventHandlerMethod.addStatement("super.getEventMetaData($S).addHandler($S)", new Object[]{eventMetaModel.getEventInternalName(), handlerData.getHandler().getClassName()})));
        this.presenterMetaModel.getPresenterKeys().stream().filter(s -> !listOfEventHandlersToCreate.contains(s)).map(s -> this.presenterMetaModel.getPresenterData((String)s)).forEach(presenterData -> presenterData.getHandledEvents().stream().filter(event -> event != null && event.trim().length() > 0).map(handledEvent -> this.processorUtils.createEventNameFromHandlingMethod((String)handledEvent)).map(event -> this.eventBusMetaModel.getEventMetaModel((String)event)).filter(Objects::nonNull).filter(eventMetaModel -> !eventMetaModel.getHandlers().contains(presenterData.getPresenter())).forEach(eventMetaModel -> loadEventHandlerMethod.addStatement("super.getEventMetaData($S).addHandler($S)", new Object[]{eventMetaModel.getEventInternalName(), presenterData.getPresenter().getClassName()})));
        this.typeSpec.addMethod(loadEventHandlerMethod.build());
    }

    private List<ClassNameModel> createListOfEventHandlersToCreate() {
        ArrayList<ClassNameModel> listOfHandlersToCreate = new ArrayList<ClassNameModel>();
        if (this.eventBusMetaModel.getShell() != null) {
            listOfHandlersToCreate.add(this.eventBusMetaModel.getShell());
        }
        this.eventBusMetaModel.getEventMetaModels().stream().forEach(eventMetaModel -> eventMetaModel.getBindings().stream().filter(handlerClassName -> this.presenterMetaModel.getPresenterData(handlerClassName.getClassName()) != null && !this.presenterMetaModel.getPresenterData(handlerClassName.getClassName()).isMultiple()).filter(handlerClassName -> !listOfHandlersToCreate.contains(handlerClassName)).forEach(listOfHandlersToCreate::add));
        this.eventBusMetaModel.getEventMetaModels().stream().forEach(eventMetaModel -> eventMetaModel.getHandlers().stream().filter(handlerClassName -> this.presenterMetaModel.getPresenterData(handlerClassName.getClassName()) != null && !this.presenterMetaModel.getPresenterData(handlerClassName.getClassName()).isMultiple()).filter(handlerClassName -> !listOfHandlersToCreate.contains(handlerClassName)).forEach(listOfHandlersToCreate::add));
        this.handlerMetaModel.getHandlerKeys().stream().filter(handlerClassName -> !listOfHandlersToCreate.contains(new ClassNameModel((String)handlerClassName))).forEach(handlerClassName -> listOfHandlersToCreate.add(new ClassNameModel((String)handlerClassName)));
        this.presenterMetaModel.getPresenterKeys().stream().filter(handlerClassName -> !this.presenterMetaModel.getPresenterData((String)handlerClassName).isMultiple()).filter(handlerClassName -> !listOfHandlersToCreate.contains(new ClassNameModel((String)handlerClassName))).forEach(handlerClassName -> listOfHandlersToCreate.add(new ClassNameModel((String)handlerClassName)));
        return listOfHandlersToCreate;
    }

    private void addHandlerToMetaList(MethodSpec.Builder methodToGenerate, ClassNameModel handlerClassName) {
        boolean isPresenter = this.presenterMetaModel.isPresenter(handlerClassName.getClassName());
        String metaDataVariableName = this.processorUtils.createFullClassName(handlerClassName.getClassName() + "MetaData");
        String metaDataClassName = this.processorUtils.setFirstCharacterToUpperCase(metaDataVariableName);
        methodToGenerate.addComment("", new Object[0]);
        methodToGenerate.addComment("===> ", new Object[0]);
        methodToGenerate.addComment("handle $N ($N)", new Object[]{handlerClassName.getClassName(), isPresenter ? "Presenter" : "EventHandler"});
        methodToGenerate.addComment("", new Object[0]);
        methodToGenerate.addStatement("$T $N = new $T()", new Object[]{ClassName.get((String)handlerClassName.getPackage(), (String)metaDataClassName, (String[])new String[0]), metaDataVariableName, ClassName.get((String)handlerClassName.getPackage(), (String)metaDataClassName, (String[])new String[0])});
        if (isPresenter) {
            if (!this.presenterMetaModel.getPresenterData(handlerClassName.getClassName()).isMultiple()) {
                this.generatePresenterBinding(methodToGenerate, handlerClassName.getClassName(), metaDataVariableName);
            }
        } else {
            methodToGenerate.addStatement("super.putHandlerMetaData($S, $N)", new Object[]{handlerClassName.getClassName(), metaDataVariableName});
            methodToGenerate.addStatement("$N.getHandler().setEventBus(this)", new Object[]{metaDataVariableName});
        }
    }

    private void generatePresenterBinding(MethodSpec.Builder methodToGenerate, String eventHandlerClassName, String metaDataVariableName) {
        methodToGenerate.addStatement("super.putPresenterMetaData($S, $N)", new Object[]{eventHandlerClassName, metaDataVariableName});
        methodToGenerate.addStatement("$N.getPresenter().setEventBus(this)", new Object[]{metaDataVariableName});
        methodToGenerate.addStatement("$N.getPresenter().setView($N.getView())", new Object[]{metaDataVariableName, metaDataVariableName});
        methodToGenerate.addStatement("$N.getView().setPresenter($N.getPresenter())", new Object[]{metaDataVariableName, metaDataVariableName});
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;
        TypeSpec.Builder typeSpec;
        EventBusMetaModel eventBusMetaModel;
        HandlerMetaModel handlerMetaModel;
        PresenterMetaModel presenterMetaModel;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvirement) {
            this.processingEnvironment = processingEnvirement;
            return this;
        }

        public Builder eventBusMetaModel(EventBusMetaModel eventBusMetaModel) {
            this.eventBusMetaModel = eventBusMetaModel;
            return this;
        }

        public Builder handlerMetaModel(HandlerMetaModel handlerMetaModel) {
            this.handlerMetaModel = handlerMetaModel;
            return this;
        }

        public Builder presenterMetaModel(PresenterMetaModel presenterMetaModel) {
            this.presenterMetaModel = presenterMetaModel;
            return this;
        }

        public Builder typeSpec(TypeSpec.Builder typeSpec) {
            this.typeSpec = typeSpec;
            return this;
        }

        public HandlerAndPresenterRegristrationGenerator build() {
            return new HandlerAndPresenterRegristrationGenerator(this);
        }
    }
}

