/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.core.internal.eventbus.AbstractEventBus;
import com.github.mvp4g.mvp4g2.processor.ProcessorException;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.generator.AddPresenterGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.DebugGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.EventHandlingMethodGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.EventLoadMetaDataGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.EventMetaDataGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.FilterGenerator;
import com.github.mvp4g.mvp4g2.processor.generator.HandlerAndPresenterRegristrationGenerator;
import com.github.mvp4g.mvp4g2.processor.model.EventBusMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.HandlerMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.HistoryMetaModel;
import com.github.mvp4g.mvp4g2.processor.model.PresenterMetaModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class EventBusGenerator {
    private static final String IMPL_NAME = "Impl";
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private TypeElement eventBusTypeElement;

    private EventBusGenerator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.eventBusTypeElement = builder.eventBusTypeElement;
        this.setUp();
    }

    private void setUp() {
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate(EventBusMetaModel eventBusMetaMetaModel, HandlerMetaModel handlerMetaModel, PresenterMetaModel presenterMetaModel, HistoryMetaModel historyMetaModel) throws ProcessorException {
        if (!this.processorUtils.doesExist(eventBusMetaMetaModel.getEventBus())) {
            return;
        }
        ClassName abstractEventBusClassName = ClassName.get(AbstractEventBus.class);
        TypeSpec.Builder typeSpec = TypeSpec.classBuilder((String)(eventBusMetaMetaModel.getEventBus().getSimpleName() + IMPL_NAME)).superclass((TypeName)ParameterizedTypeName.get((ClassName)abstractEventBusClassName, (TypeName[])new TypeName[]{eventBusMetaMetaModel.getEventBus().getTypeName()})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addSuperinterface(eventBusMetaMetaModel.getEventBus().getTypeName());
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super($S)", new Object[]{eventBusMetaMetaModel.getShell().getClassName()}).build();
        typeSpec.addMethod(constructor);
        DebugGenerator.builder().eventBusMetaModel(eventBusMetaMetaModel).typeSpec(typeSpec).build().generate();
        FilterGenerator.builder().eventBusMetaModel(eventBusMetaMetaModel).typeSpec(typeSpec).build().generate();
        EventLoadMetaDataGenerator.builder().processingEnvironment(this.processingEnvironment).eventBusMetaModel(eventBusMetaMetaModel).typeSpec(typeSpec).build().generate();
        EventMetaDataGenerator.builder().processingEnvironment(this.processingEnvironment).eventBusMetaModel(eventBusMetaMetaModel).build().generate();
        EventHandlingMethodGenerator.builder().processorUtils(this.processorUtils).typeSpec(typeSpec).eventBusMetaModel(eventBusMetaMetaModel).historyMetaModel(historyMetaModel).presenterMetaModel(presenterMetaModel).handlerMetaModel(handlerMetaModel).build().generate();
        AddPresenterGenerator.builder().typeSpec(typeSpec).processingEnvironment(this.processingEnvironment).presenterMetaModel(presenterMetaModel).build().generate();
        HandlerAndPresenterRegristrationGenerator.builder().processingEnvironment(this.processingEnvironment).typeSpec(typeSpec).eventBusMetaModel(eventBusMetaMetaModel).presenterMetaModel(presenterMetaModel).handlerMetaModel(handlerMetaModel).build().generate();
        JavaFile javaFile = JavaFile.builder((String)eventBusMetaMetaModel.getEventBus().getPackage(), (TypeSpec)typeSpec.build()).build();
        try {
            javaFile.writeTo(this.processingEnvironment.getFiler());
        }
        catch (IOException e) {
            throw new ProcessorException("Unable to write generated file: >>" + eventBusMetaMetaModel.getEventBus().getSimpleName() + IMPL_NAME + "<< -> exception: " + e.getMessage());
        }
    }

    public static class Builder {
        ProcessingEnvironment processingEnvironment;
        TypeElement eventBusTypeElement;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvironment) {
            this.processingEnvironment = processingEnvironment;
            return this;
        }

        public Builder eventBusTypeElement(TypeElement eventBusTypeElement) {
            this.eventBusTypeElement = eventBusTypeElement;
            return this;
        }

        public EventBusGenerator build() {
            return new EventBusGenerator(this);
        }
    }
}

