/*
 * Decompiled with CFR 0.152.
 */
package com.github.mvp4g.mvp4g2.processor.generator;

import com.github.mvp4g.mvp4g2.core.Mvp4g2RuntimeException;
import com.github.mvp4g.mvp4g2.core.eventbus.PresenterRegistration;
import com.github.mvp4g.mvp4g2.core.internal.eventbus.AbstractEventBus;
import com.github.mvp4g.mvp4g2.core.internal.ui.PresenterMetaDataRegistration;
import com.github.mvp4g.mvp4g2.core.ui.IsPresenter;
import com.github.mvp4g.mvp4g2.core.ui.annotation.Presenter;
import com.github.mvp4g.mvp4g2.processor.ProcessorUtils;
import com.github.mvp4g.mvp4g2.processor.model.PresenterMetaModel;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public class AddPresenterGenerator {
    private ProcessorUtils processorUtils;
    private ProcessingEnvironment processingEnvironment;
    private TypeSpec.Builder typeSpec;
    private PresenterMetaModel presenterMetaModel;

    private AddPresenterGenerator() {
    }

    private AddPresenterGenerator(Builder builder) {
        this.processingEnvironment = builder.processingEnvironment;
        this.typeSpec = builder.typeSpec;
        this.presenterMetaModel = builder.presenterMetaModel;
        this.processorUtils = ProcessorUtils.builder().processingEnvironment(this.processingEnvironment).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public void generate() {
        MethodSpec.Builder addHandlerMethod = MethodSpec.methodBuilder((String)"addHandler").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(IsPresenter.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class), WildcardTypeName.subtypeOf(Object.class)}), "presenter", new Modifier[0]).addParameter(TypeName.BOOLEAN, "bind", new Modifier[0]).returns((TypeName)ClassName.get(PresenterRegistration.class)).addException(Mvp4g2RuntimeException.class);
        List<PresenterMetaModel.PresenterData> multiPresenters = this.createPresenterTypeMultipleList();
        if (multiPresenters.size() > 0) {
            multiPresenters.forEach(presenterData -> this.generateCodeBlockForPresenter(addHandlerMethod, (PresenterMetaModel.PresenterData)presenterData));
        }
        addHandlerMethod.addStatement("throw new $T(presenter.getClass().getCanonicalName() + \": can not be used with the addHandler()-method, because it is not defined as multiple presenter!\")", new Object[]{Mvp4g2RuntimeException.class});
        this.typeSpec.addMethod(addHandlerMethod.build());
    }

    private List<PresenterMetaModel.PresenterData> createPresenterTypeMultipleList() {
        return this.presenterMetaModel.getPresenterDatas().stream().filter(PresenterMetaModel.PresenterData::isMultiple).collect(Collectors.toCollection(ArrayList::new));
    }

    private void generateCodeBlockForPresenter(MethodSpec.Builder addHandlerMethod, PresenterMetaModel.PresenterData presenterData) {
        addHandlerMethod.beginControlFlow("if (presenter instanceof $T)", new Object[]{ClassName.get((String)presenterData.getPresenter().getPackage(), (String)presenterData.getPresenter().getSimpleName(), (String[])new String[0])});
        String metaDataVariableName = this.processorUtils.createFullClassName(presenterData.getPresenter().getClassName() + "MetaData");
        String metaDataClassName = this.processorUtils.setFirstCharacterToUpperCase(metaDataVariableName);
        addHandlerMethod.addStatement("super.logAddHandler(++$T.logDepth, presenter.getClass().getCanonicalName(), bind)", new Object[]{ClassName.get(AbstractEventBus.class)});
        addHandlerMethod.addComment("", new Object[0]);
        addHandlerMethod.addComment("===> ", new Object[0]);
        addHandlerMethod.addComment("add $N to eventbus", new Object[]{presenterData.getPresenter().getClassName()});
        addHandlerMethod.addComment("", new Object[0]);
        addHandlerMethod.addStatement("$T $N = new $T()", new Object[]{ClassName.get((String)presenterData.getPresenter().getPackage(), (String)metaDataClassName, (String[])new String[0]), metaDataVariableName, ClassName.get((String)presenterData.getPresenter().getPackage(), (String)metaDataClassName, (String[])new String[0])});
        addHandlerMethod.addStatement("final $T metaDataRegistration = super.putPresenterMetaData($S, $N)", new Object[]{PresenterMetaDataRegistration.class, presenterData.getPresenter().getClassName(), metaDataVariableName});
        addHandlerMethod.addStatement("$N.setPresenter(($T) presenter)", new Object[]{metaDataVariableName, ClassName.get((String)presenterData.getPresenter().getPackage(), (String)presenterData.getPresenter().getSimpleName(), (String[])new String[0])});
        addHandlerMethod.addStatement("$N.getPresenter().setEventBus(this)", new Object[]{metaDataVariableName});
        if (Presenter.VIEW_CREATION_METHOD.FRAMEWORK.toString().equals(presenterData.getViewCreationMethod())) {
            addHandlerMethod.addStatement("$N.setView(new $T())", new Object[]{metaDataVariableName, ClassName.get((String)presenterData.getViewClass().getPackage(), (String)presenterData.getViewClass().getSimpleName(), (String[])new String[0])});
        } else {
            addHandlerMethod.addStatement("$N.setView(presenter.createView())", new Object[]{metaDataVariableName});
        }
        addHandlerMethod.addStatement("$N.getPresenter().setView($N.getView())", new Object[]{metaDataVariableName, metaDataVariableName});
        addHandlerMethod.addStatement("$N.getView().setPresenter(($T) presenter)", new Object[]{metaDataVariableName, ClassName.get((String)presenterData.getPresenter().getPackage(), (String)presenterData.getPresenter().getSimpleName(), (String[])new String[0])});
        addHandlerMethod.beginControlFlow("if (bind)", new Object[0]);
        addHandlerMethod.addStatement("$N.getPresenter().getView().setBound(true)", new Object[]{metaDataVariableName});
        addHandlerMethod.addStatement("$N.getPresenter().getView().createView()", new Object[]{metaDataVariableName});
        addHandlerMethod.addStatement("$N.getPresenter().getView().bind()", new Object[]{metaDataVariableName});
        addHandlerMethod.endControlFlow();
        StringBuilder sb = new StringBuilder();
        addHandlerMethod.addStatement(sb.append("return new $T() {").append("\n").append("@$T").append("\n").append("  public void remove() {").append("\n").append("    metaDataRegistration.remove();").append("\n").append("  }").append("\n").append("}").toString(), new Object[]{PresenterRegistration.class, Override.class});
        addHandlerMethod.endControlFlow();
    }

    public static final class Builder {
        ProcessingEnvironment processingEnvironment;
        TypeSpec.Builder typeSpec;
        PresenterMetaModel presenterMetaModel;

        public Builder processingEnvironment(ProcessingEnvironment processingEnvirement) {
            this.processingEnvironment = processingEnvirement;
            return this;
        }

        public Builder presenterMetaModel(PresenterMetaModel presenterMetaModel) {
            this.presenterMetaModel = presenterMetaModel;
            return this;
        }

        public Builder typeSpec(TypeSpec.Builder typeSpec) {
            this.typeSpec = typeSpec;
            return this;
        }

        public AddPresenterGenerator build() {
            return new AddPresenterGenerator(this);
        }
    }
}

