/*
 * Decompiled with CFR 0.152.
 */
package moxy.compiler.viewstate;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import moxy.compiler.ExtensionsKt;
import moxy.compiler.JavaFilesGenerator;
import moxy.compiler.MvpCompiler;
import moxy.compiler.Util;
import moxy.compiler.viewstate.entity.ViewInterfaceInfo;
import moxy.compiler.viewstate.entity.ViewStateMethod;
import moxy.viewstate.MvpViewState;
import moxy.viewstate.ViewCommand;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J*\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lmoxy/compiler/viewstate/ViewStateClassGenerator;", "Lmoxy/compiler/JavaFilesGenerator;", "Lmoxy/compiler/viewstate/entity/ViewInterfaceInfo;", "()V", "generate", "", "Lcom/squareup/javapoet/JavaFile;", "viewInterfaceInfo", "generateCommandClass", "Lcom/squareup/javapoet/TypeSpec;", "method", "Lmoxy/compiler/viewstate/entity/ViewStateMethod;", "viewTypeName", "Lcom/squareup/javapoet/TypeName;", "generateCommandConstructor", "Lcom/squareup/javapoet/MethodSpec;", "generateMethod", "enclosingType", "Ljavax/lang/model/type/DeclaredType;", "commandClass", "moxy-compiler"})
public final class ViewStateClassGenerator
implements JavaFilesGenerator<ViewInterfaceInfo> {
    @Override
    @NotNull
    public List<JavaFile> generate(@NotNull ViewInterfaceInfo viewInterfaceInfo) {
        Intrinsics.checkNotNullParameter((Object)viewInterfaceInfo, (String)"viewInterfaceInfo");
        ClassName viewName = viewInterfaceInfo.getName();
        TypeName nameWithTypeVariables = viewInterfaceInfo.getNameWithTypeVariables();
        DeclaredType viewInterfaceType = ExtensionsKt.asDeclaredType(viewInterfaceInfo.getElement());
        String typeName = Util.getSimpleClassName(viewInterfaceInfo.getElement()) + "$$State";
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)typeName).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ExtensionsKt.parametrizedWith(ExtensionsKt.className(Reflection.getOrCreateKotlinClass(MvpViewState.class)), nameWithTypeVariables)).addSuperinterface(nameWithTypeVariables).addTypeVariables((Iterable)viewInterfaceInfo.getTypeVariables());
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"TypeSpec.classBuilder(ty\u2026erfaceInfo.typeVariables)");
        TypeSpec.Builder classBuilder = builder;
        for (ViewStateMethod method : viewInterfaceInfo.getMethods()) {
            TypeSpec commandClass = this.generateCommandClass(method, nameWithTypeVariables);
            classBuilder.addType(commandClass);
            classBuilder.addMethod(this.generateMethod(viewInterfaceType, method, nameWithTypeVariables, commandClass));
        }
        TypeSpec typeSpec = classBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"classBuilder.build()");
        return CollectionsKt.listOf((Object)ExtensionsKt.toJavaFile(typeSpec, viewName));
    }

    private final TypeSpec generateCommandClass(ViewStateMethod method, TypeName viewTypeName) {
        MethodSpec applyMethod = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(viewTypeName, "mvpView", new Modifier[0]).addExceptions((Iterable)method.getExceptions()).addStatement("mvpView.$1L($2L)", new Object[]{method.getName(), method.getArgumentsString()}).build();
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)method.getCommandClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addTypeVariables((Iterable)method.getTypeVariables()).superclass((TypeName)ExtensionsKt.parametrizedWith(ExtensionsKt.className(Reflection.getOrCreateKotlinClass(ViewCommand.class)), viewTypeName)).addMethod(this.generateCommandConstructor(method)).addMethod(applyMethod);
        for (ParameterSpec parameter : method.getParameters()) {
            classBuilder.addField(parameter.type, parameter.name, new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        }
        TypeSpec typeSpec = classBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"classBuilder.build()");
        return typeSpec;
    }

    private final MethodSpec generateMethod(DeclaredType enclosingType, ViewStateMethod method, TypeName viewTypeName, TypeSpec commandClass) {
        String string = Util.decapitalizeString(method.getCommandClassName());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decapitalizeString(method.commandClassName)");
        String commandFieldName = string;
        String iterationVariableName = "view";
        while (StringsKt.contains$default((CharSequence)method.getArgumentsString(), (CharSequence)commandFieldName, (boolean)false, (int)2, null)) {
            commandFieldName = commandFieldName + commandFieldName.hashCode() % 10;
        }
        while (StringsKt.contains$default((CharSequence)method.getArgumentsString(), (CharSequence)iterationVariableName, (boolean)false, (int)2, null)) {
            iterationVariableName = iterationVariableName + iterationVariableName.hashCode() % 10;
        }
        return MethodSpec.overriding((ExecutableElement)method.getElement(), (DeclaredType)enclosingType, (Types)MvpCompiler.Companion.getTypeUtils()).addStatement("$1N $2L = new $1N($3L)", new Object[]{commandClass, commandFieldName, method.getArgumentsString()}).addStatement("this.viewCommands.beforeApply($1L)", new Object[]{commandFieldName}).addCode("\n", new Object[0]).beginControlFlow("if (hasNotView())", new Object[0]).addStatement("return", new Object[0]).endControlFlow().addCode("\n", new Object[0]).beginControlFlow("for ($1T " + iterationVariableName + " : this.views)", new Object[]{viewTypeName}).addStatement(iterationVariableName + ".$1L($2L)", new Object[]{method.getName(), method.getArgumentsString()}).endControlFlow().addCode("\n", new Object[0]).addStatement("this.viewCommands.afterApply($1L)", new Object[]{commandFieldName}).build();
    }

    private final MethodSpec generateCommandConstructor(ViewStateMethod method) {
        List<ParameterSpec> parameters = method.getParameters();
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addParameters((Iterable)parameters).addStatement("super($1S, $2T.class)", new Object[]{method.getStrategy().getTag(), method.getStrategy().getStrategyClass()});
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"MethodSpec.constructorBu\u2026d.strategy.strategyClass)");
        MethodSpec.Builder builder2 = builder;
        Collection collection = parameters;
        boolean bl = false;
        if (!collection.isEmpty()) {
            builder2.addCode("\n", new Object[0]);
        }
        for (ParameterSpec parameter : parameters) {
            builder2.addStatement("this.$1N = $1N", new Object[]{parameter});
        }
        return builder2.build();
    }
}

