/*
 * Decompiled with CFR 0.152.
 */
package com.github.mmin18.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.renderscript.RSRuntimeException;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.RenderScript;
import androidx.renderscript.ScriptIntrinsicBlur;
import androidx.renderscript.Type;
import com.github.mmin18.widget.BlurImpl;

public class AndroidXBlurImpl
implements BlurImpl {
    private RenderScript mRenderScript;
    private ScriptIntrinsicBlur mBlurScript;
    private Allocation mBlurInput;
    private Allocation mBlurOutput;
    static Boolean DEBUG = null;

    public boolean prepare(Context context, Bitmap buffer, float radius) {
        if (this.mRenderScript == null) {
            try {
                this.mRenderScript = RenderScript.create((Context)context);
                this.mBlurScript = ScriptIntrinsicBlur.create((RenderScript)this.mRenderScript, (Element)Element.U8_4((RenderScript)this.mRenderScript));
            }
            catch (RSRuntimeException e) {
                if (AndroidXBlurImpl.isDebug(context)) {
                    throw e;
                }
                this.release();
                return false;
            }
        }
        this.mBlurScript.setRadius(radius);
        this.mBlurInput = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)buffer, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
        this.mBlurOutput = Allocation.createTyped((RenderScript)this.mRenderScript, (Type)this.mBlurInput.getType());
        return true;
    }

    public void release() {
        if (this.mBlurInput != null) {
            this.mBlurInput.destroy();
            this.mBlurInput = null;
        }
        if (this.mBlurOutput != null) {
            this.mBlurOutput.destroy();
            this.mBlurOutput = null;
        }
        if (this.mBlurScript != null) {
            this.mBlurScript.destroy();
            this.mBlurScript = null;
        }
        if (this.mRenderScript != null) {
            this.mRenderScript.destroy();
            this.mRenderScript = null;
        }
    }

    public void blur(Bitmap input, Bitmap output) {
        this.mBlurInput.copyFrom(input);
        this.mBlurScript.setInput(this.mBlurInput);
        this.mBlurScript.forEach(this.mBlurOutput);
        this.mBlurOutput.copyTo(output);
    }

    static boolean isDebug(Context ctx) {
        if (DEBUG == null && ctx != null) {
            DEBUG = (ctx.getApplicationInfo().flags & 2) != 0;
        }
        return DEBUG == Boolean.TRUE;
    }
}

