/*
 * Decompiled with CFR 0.152.
 */
package com.github.mmin18.widget;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewTreeObserver;
import com.github.mmin18.realtimeblurview.R;
import com.github.mmin18.widget.AndroidStockBlurImpl;
import com.github.mmin18.widget.AndroidXBlurImpl;
import com.github.mmin18.widget.BlurImpl;
import com.github.mmin18.widget.SupportLibraryBlurImpl;

public class RealtimeBlurView
extends View {
    private float mDownsampleFactor;
    private int mOverlayColor;
    private float mBlurRadius;
    private final BlurImpl mBlurImpl;
    private boolean mDirty;
    private Bitmap mBitmapToBlur;
    private Bitmap mBlurredBitmap;
    private Canvas mBlurringCanvas;
    private boolean mIsRendering;
    private Paint mPaint;
    private final Rect mRectSrc = new Rect();
    private final Rect mRectDst = new Rect();
    private View mDecorView;
    private boolean mDifferentRoot;
    private static int RENDERING_COUNT;
    private static int BLUR_IMPL;
    private final ViewTreeObserver.OnPreDrawListener preDrawListener = new ViewTreeObserver.OnPreDrawListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onPreDraw() {
            int[] locations = new int[2];
            Bitmap oldBmp = RealtimeBlurView.this.mBlurredBitmap;
            View decor = RealtimeBlurView.this.mDecorView;
            if (decor != null && RealtimeBlurView.this.isShown() && RealtimeBlurView.this.prepare()) {
                boolean redrawBitmap = RealtimeBlurView.this.mBlurredBitmap != oldBmp;
                oldBmp = null;
                decor.getLocationOnScreen(locations);
                int x = -locations[0];
                int y = -locations[1];
                RealtimeBlurView.this.getLocationOnScreen(locations);
                x += locations[0];
                y += locations[1];
                RealtimeBlurView.this.mBitmapToBlur.eraseColor(RealtimeBlurView.this.mOverlayColor & 0xFFFFFF);
                int rc = RealtimeBlurView.this.mBlurringCanvas.save();
                RealtimeBlurView.this.mIsRendering = true;
                RENDERING_COUNT++;
                try {
                    RealtimeBlurView.this.mBlurringCanvas.scale(1.0f * (float)RealtimeBlurView.this.mBitmapToBlur.getWidth() / (float)RealtimeBlurView.this.getWidth(), 1.0f * (float)RealtimeBlurView.this.mBitmapToBlur.getHeight() / (float)RealtimeBlurView.this.getHeight());
                    RealtimeBlurView.this.mBlurringCanvas.translate((float)(-x), (float)(-y));
                    if (decor.getBackground() != null) {
                        decor.getBackground().draw(RealtimeBlurView.this.mBlurringCanvas);
                    }
                    decor.draw(RealtimeBlurView.this.mBlurringCanvas);
                }
                catch (StopException stopException) {
                }
                finally {
                    RealtimeBlurView.this.mIsRendering = false;
                    RENDERING_COUNT--;
                    RealtimeBlurView.this.mBlurringCanvas.restoreToCount(rc);
                }
                RealtimeBlurView.this.blur(RealtimeBlurView.this.mBitmapToBlur, RealtimeBlurView.this.mBlurredBitmap);
                if (redrawBitmap || RealtimeBlurView.this.mDifferentRoot) {
                    RealtimeBlurView.this.invalidate();
                }
            }
            return true;
        }
    };
    private static StopException STOP_EXCEPTION;

    public RealtimeBlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mBlurImpl = this.getBlurImpl();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.RealtimeBlurView);
        this.mBlurRadius = a.getDimension(R.styleable.RealtimeBlurView_realtimeBlurRadius, TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)context.getResources().getDisplayMetrics()));
        this.mDownsampleFactor = a.getFloat(R.styleable.RealtimeBlurView_realtimeDownsampleFactor, 4.0f);
        this.mOverlayColor = a.getColor(R.styleable.RealtimeBlurView_realtimeOverlayColor, -1426063361);
        a.recycle();
        this.mPaint = new Paint();
    }

    protected BlurImpl getBlurImpl() {
        if (BLUR_IMPL == 0) {
            try {
                ((Object)((Object)this)).getClass().getClassLoader().loadClass("androidx.renderscript.RenderScript");
                BLUR_IMPL = 1;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (BLUR_IMPL == 0) {
            try {
                ((Object)((Object)this)).getClass().getClassLoader().loadClass("android.support.v8.renderscript.RenderScript");
                BLUR_IMPL = 2;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        switch (BLUR_IMPL) {
            case 1: {
                return new AndroidXBlurImpl();
            }
            case 2: {
                return new SupportLibraryBlurImpl();
            }
        }
        BLUR_IMPL = -1;
        return new AndroidStockBlurImpl();
    }

    public void setBlurRadius(float radius) {
        if (this.mBlurRadius != radius) {
            this.mBlurRadius = radius;
            this.mDirty = true;
            this.invalidate();
        }
    }

    public void setDownsampleFactor(float factor) {
        if (factor <= 0.0f) {
            throw new IllegalArgumentException("Downsample factor must be greater than 0.");
        }
        if (this.mDownsampleFactor != factor) {
            this.mDownsampleFactor = factor;
            this.mDirty = true;
            this.releaseBitmap();
            this.invalidate();
        }
    }

    public void setOverlayColor(int color) {
        if (this.mOverlayColor != color) {
            this.mOverlayColor = color;
            this.invalidate();
        }
    }

    private void releaseBitmap() {
        if (this.mBitmapToBlur != null) {
            this.mBitmapToBlur.recycle();
            this.mBitmapToBlur = null;
        }
        if (this.mBlurredBitmap != null) {
            this.mBlurredBitmap.recycle();
            this.mBlurredBitmap = null;
        }
    }

    protected void release() {
        this.releaseBitmap();
        this.mBlurImpl.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean prepare() {
        if (this.mBlurRadius == 0.0f) {
            this.release();
            return false;
        }
        float downsampleFactor = this.mDownsampleFactor;
        float radius = this.mBlurRadius / downsampleFactor;
        if (radius > 25.0f) {
            downsampleFactor = downsampleFactor * radius / 25.0f;
            radius = 25.0f;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int scaledWidth = Math.max(1, (int)((float)width / downsampleFactor));
        int scaledHeight = Math.max(1, (int)((float)height / downsampleFactor));
        boolean dirty = this.mDirty;
        if (this.mBlurringCanvas == null || this.mBlurredBitmap == null || this.mBlurredBitmap.getWidth() != scaledWidth || this.mBlurredBitmap.getHeight() != scaledHeight) {
            dirty = true;
            this.releaseBitmap();
            boolean r = false;
            try {
                this.mBitmapToBlur = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (this.mBitmapToBlur == null) {
                    boolean bl = false;
                    return bl;
                }
                this.mBlurringCanvas = new Canvas(this.mBitmapToBlur);
                this.mBlurredBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                if (this.mBlurredBitmap == null) {
                    boolean bl = false;
                    return bl;
                }
                r = true;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                if (!r) {
                    this.release();
                    return false;
                }
            }
            finally {
                if (!r) {
                    this.release();
                    return false;
                }
            }
        }
        if (dirty) {
            if (this.mBlurImpl.prepare(this.getContext(), this.mBitmapToBlur, radius)) {
                this.mDirty = false;
            } else {
                return false;
            }
        }
        return true;
    }

    protected void blur(Bitmap bitmapToBlur, Bitmap blurredBitmap) {
        this.mBlurImpl.blur(bitmapToBlur, blurredBitmap);
    }

    protected View getActivityDecorView() {
        Context ctx = this.getContext();
        for (int i = 0; i < 4 && ctx != null && !(ctx instanceof Activity) && ctx instanceof ContextWrapper; ++i) {
            ctx = ((ContextWrapper)ctx).getBaseContext();
        }
        if (ctx instanceof Activity) {
            return ((Activity)ctx).getWindow().getDecorView();
        }
        return null;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mDecorView = this.getActivityDecorView();
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().addOnPreDrawListener(this.preDrawListener);
            boolean bl = this.mDifferentRoot = this.mDecorView.getRootView() != this.getRootView();
            if (this.mDifferentRoot) {
                this.mDecorView.postInvalidate();
            }
        } else {
            this.mDifferentRoot = false;
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mDecorView != null) {
            this.mDecorView.getViewTreeObserver().removeOnPreDrawListener(this.preDrawListener);
        }
        this.release();
        super.onDetachedFromWindow();
    }

    public void draw(Canvas canvas) {
        if (this.mIsRendering) {
            throw STOP_EXCEPTION;
        }
        if (RENDERING_COUNT <= 0) {
            super.draw(canvas);
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBlurredBitmap(canvas, this.mBlurredBitmap, this.mOverlayColor);
    }

    protected void drawBlurredBitmap(Canvas canvas, Bitmap blurredBitmap, int overlayColor) {
        if (blurredBitmap != null) {
            this.mRectSrc.right = blurredBitmap.getWidth();
            this.mRectSrc.bottom = blurredBitmap.getHeight();
            this.mRectDst.right = this.getWidth();
            this.mRectDst.bottom = this.getHeight();
            canvas.drawBitmap(blurredBitmap, this.mRectSrc, this.mRectDst, null);
        }
        this.mPaint.setColor(overlayColor);
        canvas.drawRect(this.mRectDst, this.mPaint);
    }

    static {
        STOP_EXCEPTION = new StopException();
    }

    private static class StopException
    extends RuntimeException {
        private StopException() {
        }
    }
}

