/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.runner.runtime;

import com.github.mkolisnyk.cucumber.runner.ExtendedCucumberOptions;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ExtendedRuntimeOptions {
    private boolean isOverviewReport = false;
    private boolean isOverviewChartsReport = false;
    private boolean isUsageReport = false;
    private boolean isDetailedReport = false;
    private boolean isDetailedAggregatedReport = false;
    private boolean isCoverageReport = false;
    private String[] jsonReportPaths;
    private String outputFolder;
    private String reportPrefix;
    private int retryCount = 0;
    private String screenShotSize = "";
    private boolean toPDF = false;
    private String pdfPageSize = "auto";
    private String[] jsonUsageReportPaths;
    private String screenShotLocation = "";
    private String[] includeCoverageTags = new String[0];
    private String[] excludeCoverageTags = new String[0];
    private boolean breakdownReport = false;
    private String breakdownConfig = "";
    private boolean featureMapReport = false;
    private String featureMapConfig = "";
    private boolean featureOverviewChart = false;
    private boolean knownErrorsReport = false;
    private String knownErrorsConfig = "";
    private boolean consolidatedReport = false;
    private String consolidatedReportConfig = "";
    private int threadsCount;
    private String threadsCountValue;

    private String[] joinPaths(String singlePath, String[] arrayPath) {
        Object[] result = new String[]{};
        if (StringUtils.isNotBlank((CharSequence)singlePath)) {
            result = (String[])ArrayUtils.add((Object[])result, (Object)singlePath);
        }
        if (arrayPath != null && arrayPath.length > 0) {
            result = (String[])ArrayUtils.addAll((Object[])result, (Object[])arrayPath);
        }
        return result;
    }

    public ExtendedRuntimeOptions() {
    }

    public ExtendedRuntimeOptions(ExtendedCucumberOptions options) throws Exception {
        if (options != null) {
            this.isOverviewReport = options.overviewReport();
            this.isOverviewChartsReport = options.overviewChartsReport();
            this.isUsageReport = options.usageReport();
            this.isDetailedReport = options.detailedReport();
            this.isDetailedAggregatedReport = options.detailedAggregatedReport();
            this.isCoverageReport = options.coverageReport();
            this.jsonReportPaths = this.joinPaths(options.jsonReport(), options.jsonReports());
            this.outputFolder = options.outputFolder();
            this.reportPrefix = options.reportPrefix();
            this.retryCount = options.retryCount();
            this.screenShotSize = options.screenShotSize();
            this.toPDF = options.toPDF();
            this.pdfPageSize = options.pdfPageSize();
            this.jsonUsageReportPaths = this.joinPaths(options.jsonUsageReport(), options.jsonUsageReports());
            this.screenShotLocation = options.screenShotLocation();
            this.includeCoverageTags = options.includeCoverageTags();
            this.excludeCoverageTags = options.excludeCoverageTags();
            this.breakdownReport = options.breakdownReport();
            this.breakdownConfig = options.breakdownConfig();
            this.featureMapReport = options.featureMapReport();
            this.featureMapConfig = options.featureMapConfig();
            this.featureOverviewChart = options.featureOverviewChart();
            this.knownErrorsReport = options.knownErrorsReport();
            this.knownErrorsConfig = options.knownErrorsConfig();
            this.consolidatedReport = options.consolidatedReport();
            this.consolidatedReportConfig = options.consolidatedReportConfig();
            this.threadsCount = options.threadsCount();
            this.threadsCountValue = options.threadsCountValue();
        }
        for (Field field : this.getClass().getDeclaredFields()) {
            String propertyName = "cucumber.reports." + field.getName();
            if (!System.getProperties().containsKey(propertyName)) continue;
            if (field.getType().equals(Boolean.TYPE)) {
                field.setBoolean(this, System.getProperty(propertyName).equalsIgnoreCase("true"));
                continue;
            }
            if (field.getType().equals(Integer.TYPE)) {
                field.setInt(this, Integer.valueOf(System.getProperty(propertyName)));
                continue;
            }
            field.set(this, System.getProperty(propertyName));
        }
    }

    public final boolean isOverviewReport() {
        return this.isOverviewReport;
    }

    public boolean isOverviewChartsReport() {
        return this.isOverviewChartsReport;
    }

    public final boolean isUsageReport() {
        return this.isUsageReport;
    }

    public final boolean isDetailedReport() {
        return this.isDetailedReport;
    }

    public final boolean isDetailedAggregatedReport() {
        return this.isDetailedAggregatedReport;
    }

    public final boolean isCoverageReport() {
        return this.isCoverageReport;
    }

    public final String[] getJsonReportPaths() {
        return this.jsonReportPaths;
    }

    public final void setJsonReportPaths(String[] newPaths) {
        this.jsonReportPaths = newPaths;
    }

    public final String getOutputFolder() {
        return this.outputFolder;
    }

    public final String getReportPrefix() {
        return this.reportPrefix;
    }

    public final int getRetryCount() {
        return this.retryCount;
    }

    public final String getScreenShotSize() {
        return this.screenShotSize;
    }

    public final boolean isToPDF() {
        return this.toPDF;
    }

    public String getPdfPageSize() {
        return this.pdfPageSize;
    }

    public final String[] getJsonUsageReportPaths() {
        return this.jsonUsageReportPaths;
    }

    public final void setJsonUsageReportPaths(String[] newPaths) {
        this.jsonUsageReportPaths = newPaths;
    }

    public final String getScreenShotLocation() {
        return this.screenShotLocation;
    }

    public final String[] getIncludeCoverageTags() {
        return this.includeCoverageTags;
    }

    public final void setIncludeCoverageTags(String[] includeCoverageTagsValue) {
        this.includeCoverageTags = includeCoverageTagsValue;
    }

    public final String[] getExcludeCoverageTags() {
        return this.excludeCoverageTags;
    }

    public final void setExcludeCoverageTags(String[] excludeCoverageTagsValue) {
        this.excludeCoverageTags = excludeCoverageTagsValue;
    }

    public boolean isBreakdownReport() {
        return this.breakdownReport;
    }

    public String getBreakdownConfig() {
        return this.breakdownConfig;
    }

    public boolean isFeatureMapReport() {
        return this.featureMapReport;
    }

    public String getFeatureMapConfig() {
        return this.featureMapConfig;
    }

    public boolean isFeatureOverviewChart() {
        return this.featureOverviewChart;
    }

    public boolean isKnownErrorsReport() {
        return this.knownErrorsReport;
    }

    public String getKnownErrorsConfig() {
        return this.knownErrorsConfig;
    }

    public boolean isConsolidatedReport() {
        return this.consolidatedReport;
    }

    public String getConsolidatedReportConfig() {
        return this.consolidatedReportConfig;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public String getThreadsCountValue() {
        return this.threadsCountValue;
    }

    public void setOverviewReport(boolean isOverviewReportValue) {
        this.isOverviewReport = isOverviewReportValue;
    }

    public void setUsageReport(boolean isUsageReportValue) {
        this.isUsageReport = isUsageReportValue;
    }

    public void setDetailedReport(boolean isDetailedReportValue) {
        this.isDetailedReport = isDetailedReportValue;
    }

    public void setDetailedAggregatedReport(boolean isDetailedAggregatedReportValue) {
        this.isDetailedAggregatedReport = isDetailedAggregatedReportValue;
    }

    public void setCoverageReport(boolean isCoverageReportValue) {
        this.isCoverageReport = isCoverageReportValue;
    }

    public void setOutputFolder(String outputFolderValue) {
        this.outputFolder = outputFolderValue;
    }

    public void setReportPrefix(String reportPrefixValue) {
        this.reportPrefix = reportPrefixValue;
    }

    public void setRetryCount(int retryCountValue) {
        this.retryCount = retryCountValue;
    }

    public void setScreenShotSize(String screenShotSizeValue) {
        this.screenShotSize = screenShotSizeValue;
    }

    public void setToPDF(boolean toPDFValue) {
        this.toPDF = toPDFValue;
    }

    public void setPdfPageSize(String pdfPageSizeValue) {
        this.pdfPageSize = pdfPageSizeValue;
    }

    public void setScreenShotLocation(String screenShotLocationValue) {
        this.screenShotLocation = screenShotLocationValue;
    }

    public void setBreakdownReport(boolean breakdownReportValue) {
        this.breakdownReport = breakdownReportValue;
    }

    public void setBreakdownConfig(String breakdownConfigValue) {
        this.breakdownConfig = breakdownConfigValue;
    }

    public void setFeatureMapReport(boolean featureMapReportValue) {
        this.featureMapReport = featureMapReportValue;
    }

    public void setFeatureMapConfig(String featureMapConfigValue) {
        this.featureMapConfig = featureMapConfigValue;
    }

    public void setFeatureOverviewChart(boolean featureOverviewChartValue) {
        this.featureOverviewChart = featureOverviewChartValue;
    }

    public void setKnownErrorsReport(boolean knownErrorsReportValue) {
        this.knownErrorsReport = knownErrorsReportValue;
    }

    public void setKnownErrorsConfig(String knownErrorsConfigValue) {
        this.knownErrorsConfig = knownErrorsConfigValue;
    }

    public void setConsolidatedReport(boolean consolidatedReportValue) {
        this.consolidatedReport = consolidatedReportValue;
    }

    public void setConsolidatedReportConfig(String consolidatedReportConfigValue) {
        this.consolidatedReportConfig = consolidatedReportConfigValue;
    }

    public void setOverviewChartsReport(boolean isOverviewChartsReportValue) {
        this.isOverviewChartsReport = isOverviewChartsReportValue;
    }

    public static ExtendedRuntimeOptions[] init(Class<?> clazz) throws Exception {
        ExtendedCucumberOptions[] options = (ExtendedCucumberOptions[])clazz.getAnnotationsByType(ExtendedCucumberOptions.class);
        return ExtendedRuntimeOptions.init(options);
    }

    public static ExtendedRuntimeOptions[] init(ExtendedCucumberOptions[] options) throws Exception {
        Object[] result = new ExtendedRuntimeOptions[]{};
        for (ExtendedCucumberOptions option : options) {
            ExtendedRuntimeOptions runtimeOption = new ExtendedRuntimeOptions(option);
            result = (ExtendedRuntimeOptions[])ArrayUtils.add((Object[])result, (Object)runtimeOption);
        }
        return result;
    }

    public String toString() {
        return "ExtendedRuntimeOptions [isOverviewReport=" + this.isOverviewReport + ", isOverviewChartsReport=" + this.isOverviewChartsReport + ", isUsageReport=" + this.isUsageReport + ", isDetailedReport=" + this.isDetailedReport + ", isDetailedAggregatedReport=" + this.isDetailedAggregatedReport + ", isCoverageReport=" + this.isCoverageReport + ", jsonReportPaths=" + Arrays.toString(this.jsonReportPaths) + ", outputFolder=" + this.outputFolder + ", reportPrefix=" + this.reportPrefix + ", retryCount=" + this.retryCount + ", screenShotSize=" + this.screenShotSize + ", toPDF=" + this.toPDF + ", pdfPageSize=" + this.pdfPageSize + ", jsonUsageReportPaths=" + Arrays.toString(this.jsonUsageReportPaths) + ", screenShotLocation=" + this.screenShotLocation + ", includeCoverageTags=" + Arrays.toString(this.includeCoverageTags) + ", excludeCoverageTags=" + Arrays.toString(this.excludeCoverageTags) + ", breakdownReport=" + this.breakdownReport + ", breakdownConfig=" + this.breakdownConfig + ", featureMapReport=" + this.featureMapReport + ", featureMapConfig=" + this.featureMapConfig + ", featureOverviewChart=" + this.featureOverviewChart + ", knownErrorsReport=" + this.knownErrorsReport + ", knownErrorsConfig=" + this.knownErrorsConfig + ", consolidatedReport=" + this.consolidatedReport + ", consolidatedReportConfig=" + this.consolidatedReportConfig + ", threadsCount=" + this.threadsCount + ", threadsCountValue=" + this.threadsCountValue + "]";
    }
}

