/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.result;

import com.cedarsoftware.util.io.JsonObject;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.BaseMatcher;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.matchers.Matcher;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsInfo;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsModel;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberTagResults;
import com.github.mkolisnyk.cucumber.reporting.utils.helpers.JsonUtils;
import org.apache.commons.lang.ArrayUtils;

public class CucumberFeatureResult {
    private String id;
    private CucumberTagResults[] tags;
    private String description;
    private String name;
    private Long line;
    private CucumberScenarioResult[] elements;
    private float duration;
    private String[] includeCoverageTags = new String[0];
    private String[] excludeCoverageTags = new String[0];
    private int passed = 0;
    private int failed = 0;
    private int undefined = 0;
    private int skipped = 0;
    private int known = 0;

    public CucumberFeatureResult(JsonObject<String, Object> json) {
        this.id = (String)json.get((Object)"id");
        this.tags = JsonUtils.toTagArray(json);
        this.description = (String)json.get((Object)"description");
        this.name = (String)json.get((Object)"name");
        this.line = (Long)json.get((Object)"line");
        Object[] objs = new Object[]{};
        if (json.get((Object)"elements") != null) {
            objs = (Object[])((JsonObject)json.get((Object)"elements")).get((Object)"@items");
        }
        this.elements = new CucumberScenarioResult[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            this.elements[i] = new CucumberScenarioResult((JsonObject<String, Object>)((JsonObject)objs[i]));
            this.elements[i].setFeature(this);
        }
    }

    public void valuateKnownErrors(KnownErrorsModel batch) {
        block0: for (CucumberScenarioResult scenario : this.elements) {
            for (KnownErrorsInfo info : batch.getErrorDescriptions()) {
                Matcher matcher = BaseMatcher.create(info.getFilter().getDimensionValue());
                if (!matcher.matches(scenario, info.getFilter())) continue;
                scenario.updateFailedToKnown();
                continue block0;
            }
        }
    }

    public void valuate() {
        this.passed = 0;
        this.failed = 0;
        this.undefined = 0;
        this.skipped = 0;
        this.known = 0;
        this.duration = 0.0f;
        for (CucumberScenarioResult scenario : this.elements) {
            boolean isBackground = scenario.getType().equalsIgnoreCase("background");
            scenario.valuate();
            if (!scenario.isInTagSet(this.includeCoverageTags, this.excludeCoverageTags)) {
                ++this.undefined;
            } else if (scenario.getSteps() == null || scenario.getSteps().length <= 0) {
                ++this.undefined;
            } else if (!isBackground) {
                if (scenario.getFailed() > 0) {
                    ++this.failed;
                } else if (scenario.getKnown() > 0) {
                    ++this.known;
                } else if (scenario.getUndefined() > 0) {
                    ++this.undefined;
                } else if (scenario.getSkipped() > 0) {
                    ++this.skipped;
                } else {
                    ++this.passed;
                }
            }
            this.duration = (float)((double)this.duration + scenario.getDuration());
        }
    }

    public String getStatus() {
        this.valuate();
        if (this.getFailed() > 0) {
            return "failed";
        }
        if (this.getKnown() > 0) {
            return "known";
        }
        if (this.getUndefined() > 0) {
            return "undefined";
        }
        if (this.getSkipped() > 0) {
            return "skipped";
        }
        return "passed";
    }

    public boolean isInTagSet(String[] include, String[] exclude) {
        Object[] tagValues = this.getAllTags(false);
        for (String tag : include) {
            if (!ArrayUtils.contains((Object[])tagValues, (Object)tag)) continue;
            return true;
        }
        for (String tag : exclude) {
            if (!ArrayUtils.contains((Object[])tagValues, (Object)tag)) continue;
            return false;
        }
        for (CucumberScenarioResult scenario : this.getElements()) {
            if (scenario.isInTagSet(include, exclude)) continue;
            return false;
        }
        return true;
    }

    public final int getPassed() {
        return this.passed;
    }

    public final int getFailed() {
        return this.failed;
    }

    public final int getUndefined() {
        return this.undefined;
    }

    public final int getSkipped() {
        return this.skipped;
    }

    public int getKnown() {
        return this.known;
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String idValue) {
        this.id = idValue;
    }

    public final CucumberTagResults[] getTags() {
        return this.tags;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name;
    }

    public final Long getLine() {
        return this.line;
    }

    public final CucumberScenarioResult[] getElements() {
        return this.elements;
    }

    public final float getDuration() {
        return this.duration;
    }

    public void aggregateScenarioResults(boolean collapse) {
        String prevId = "";
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].getKeyword().equalsIgnoreCase("Background")) continue;
            String currentId = "" + this.elements[i].getLine() + "-" + this.elements[i].getId();
            if (currentId.equals(prevId)) {
                this.elements[i].addRerunAttempts(this.elements[i - 1].getRerunAttempts() + 1);
                if (collapse) {
                    this.elements = (CucumberScenarioResult[])ArrayUtils.remove((Object[])this.elements, (int)(i - 1));
                    --i;
                    prevId = currentId;
                    continue;
                }
                prevId = currentId;
                this.elements[i].setId(String.format("%s-retry%d", currentId, this.elements[i].getRerunAttempts()));
                this.elements[i].setName(String.format("%s (retry %d)", this.elements[i].getName(), this.elements[i].getRerunAttempts()));
                continue;
            }
            prevId = currentId;
            this.elements[i].setId(currentId);
        }
    }

    public String[] getAllTags(boolean includeScenarioTags) {
        Object[] result = new String[]{};
        for (CucumberTagResults tag : this.getTags()) {
            result = (String[])ArrayUtils.add((Object[])result, (Object)tag.getName());
        }
        if (includeScenarioTags) {
            for (CucumberScenarioResult scenario : this.getElements()) {
                for (String tag : scenario.getAllTags()) {
                    if (ArrayUtils.contains((Object[])result, (Object)tag)) continue;
                    result = (String[])ArrayUtils.add((Object[])result, (Object)tag);
                }
            }
        }
        return result;
    }

    public final String[] getIncludeCoverageTags() {
        return this.includeCoverageTags;
    }

    public final void setIncludeCoverageTags(String[] includeCoverageTagsValue) {
        this.includeCoverageTags = includeCoverageTagsValue;
    }

    public final String[] getExcludeCoverageTags() {
        return this.excludeCoverageTags;
    }

    public final void setExcludeCoverageTags(String[] excludeCoverageTagsValue) {
        this.excludeCoverageTags = excludeCoverageTagsValue;
    }
}

