/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.interfaces.KECompatibleReport;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportError;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsModel;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.utils.drawers.PieChartDrawer;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;

public class CucumberResultsOverview
extends KECompatibleReport {
    public CucumberResultsOverview() {
    }

    public CucumberResultsOverview(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
    }

    protected String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/feature-overview-tmpl.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    @Override
    public int[][] getStatuses(CucumberFeatureResult[] results) {
        int kePosition = 3;
        int[][] statuses = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}};
        for (CucumberFeatureResult result : results) {
            if (result.getStatus().trim().equalsIgnoreCase("passed")) {
                int[] nArray = statuses[0];
                nArray[0] = nArray[0] + 1;
            } else if (result.getStatus().trim().equalsIgnoreCase("failed")) {
                int[] nArray = statuses[0];
                nArray[1] = nArray[1] + 1;
            } else if (result.getStatus().trim().equalsIgnoreCase("known")) {
                int[] nArray = statuses[0];
                nArray[3] = nArray[3] + 1;
            } else {
                int[] nArray = statuses[0];
                nArray[2] = nArray[2] + 1;
            }
            for (CucumberScenarioResult element : result.getElements()) {
                if (element.getStatus().trim().equalsIgnoreCase("passed")) {
                    int[] nArray = statuses[1];
                    nArray[0] = nArray[0] + 1;
                } else if (element.getStatus().trim().equalsIgnoreCase("failed")) {
                    int[] nArray = statuses[1];
                    nArray[1] = nArray[1] + 1;
                } else if (element.getStatus().trim().equalsIgnoreCase("known")) {
                    int[] nArray = statuses[1];
                    nArray[3] = nArray[3] + 1;
                } else {
                    int[] nArray = statuses[1];
                    nArray[2] = nArray[2] + 1;
                }
                int[] nArray = statuses[2];
                nArray[0] = nArray[0] + element.getPassed();
                int[] nArray2 = statuses[2];
                nArray2[1] = nArray2[1] + element.getFailed();
                int[] nArray3 = statuses[2];
                nArray3[2] = nArray3[2] + (element.getSkipped() + element.getUndefined());
                int[] nArray4 = statuses[2];
                nArray4[3] = nArray4[3] + element.getKnown();
            }
        }
        return statuses;
    }

    protected String generateFeatureOverview(CucumberFeatureResult[] results) throws IOException {
        String content = this.getReportBase();
        content = content.replaceAll("__TITLE__", "Features Overview");
        String reportContent = "";
        reportContent = reportContent + "<h1>Features Status</h1><table><tr><th>Feature Name</th><th>Status</th><th>Passed</th><th>Failed</th><th>Known</th><th>Undefined</th><th>Duration</th></tr>";
        for (CucumberFeatureResult cucumberFeatureResult : results) {
            reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%d</td><td>%d</td><td>%.2fs</td></tr>", cucumberFeatureResult.getStatus(), cucumberFeatureResult.getName(), cucumberFeatureResult.getStatus(), cucumberFeatureResult.getPassed(), cucumberFeatureResult.getFailed(), cucumberFeatureResult.getKnown(), cucumberFeatureResult.getUndefined() + cucumberFeatureResult.getSkipped(), Float.valueOf(cucumberFeatureResult.getDuration()));
        }
        reportContent = reportContent + "</table>";
        reportContent = reportContent + "<h1>Scenario Status</h1><table><tr><th>Feature Name</th><th>Scenario</th><th>Status</th><th>Passed</th><th>Failed</th><th>Known</th><th>Undefined</th><th>Retries</th><th>Duration</th></tr>";
        int[][] statuses = this.getStatuses(results);
        int[] featureStatuses = statuses[0];
        int[] scenarioStatuses = statuses[1];
        for (CucumberFeatureResult result : results) {
            for (CucumberScenarioResult element : result.getElements()) {
                reportContent = reportContent + String.format(Locale.US, "<tr class=\"%s\"><td>%s</td><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%d</td><td>%d</td><td>%d</td><td>%.2fs</td></tr>", element.getStatus(), result.getName(), element.getName(), element.getStatus(), element.getPassed(), element.getFailed(), element.getKnown(), element.getUndefined() + element.getSkipped(), element.getRerunAttempts(), element.getDuration());
            }
        }
        reportContent = reportContent + "</table>";
        content = content.replaceAll("__REPORT__", reportContent);
        PieChartDrawer pieChartDrawer = new PieChartDrawer();
        content = content.replaceAll("__FEATURE_DATA__", pieChartDrawer.generatePieChart(450, 300, featureStatuses, new String[]{"Passed", "Failed", "Undefined", "Known"}, new String[]{"green", "red", "silver", "gold"}, new String[]{"darkgreen", "darkred", "darkgray", "goldenrod"}, 20, 2));
        content = content.replaceAll("__SCENARIO_DATA__", pieChartDrawer.generatePieChart(450, 300, scenarioStatuses, new String[]{"Passed", "Failed", "Undefined", "Known"}, new String[]{"green", "red", "silver", "gold"}, new String[]{"darkgreen", "darkred", "darkgray", "goldenrod"}, 20, 2));
        return content;
    }

    protected void executeOverviewReport(String reportSuffix) throws Exception {
        this.executeOverviewReport(reportSuffix, false);
    }

    protected void executeOverviewReport(String reportSuffix, boolean toPdf) throws Exception {
        this.executeOverviewReport(null, reportSuffix, toPdf);
    }

    protected void executeOverviewReport(KnownErrorsModel batch, String reportSuffix, boolean toPdf) throws Exception {
        this.validateParameters();
        CucumberFeatureResult[] features = this.readFileContent(true);
        if (batch != null) {
            for (CucumberFeatureResult feature : features) {
                feature.valuateKnownErrors(batch);
            }
        }
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + reportSuffix + ".html");
        FileUtils.writeStringToFile((File)outFile, (String)this.generateFeatureOverview(features));
        if (toPdf) {
            this.exportToPDF(outFile, reportSuffix);
        }
        try {
            outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + reportSuffix + "-dump.xml");
            this.dumpOverviewStats(outFile, features);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.RESULTS_OVERVIEW;
    }

    @Override
    public void validateParameters() {
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_SOURCE_FILE, ""), (Object)this.getSourceFiles());
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_DIRECTORY, ""), (Object)this.getOutputDirectory());
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_NAME, ""), (Object)this.getOutputName());
        for (String sourceFile : this.getSourceFiles()) {
            Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_SOURCE_FILE, ""), (Object)sourceFile);
            File path = new File(sourceFile);
            Assert.assertTrue((String)(this.constructErrorMessage(CucumberReportError.NON_EXISTING_SOURCE_FILE, "") + ". Was looking for path: \"" + path.getAbsolutePath() + "\""), (boolean)path.exists());
        }
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.RESULTS_OVERVIEW_URL;
    }

    @Override
    public void execute(boolean toPDF) throws Exception {
        this.executeOverviewReport("feature-overview", toPDF);
    }

    @Override
    public void execute(boolean aggregate, boolean toPDF) throws Exception {
        this.executeOverviewReport("feature-overview", toPDF);
    }

    @Override
    public void execute(KnownErrorsModel batch, boolean aggregate, boolean toPDF) throws Exception {
        this.executeOverviewReport(batch, "feature-overview", toPDF);
    }
}

