/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjdev.libaums.storageprovider.util;

import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class ParcelFileDescriptorUtil {
    public static ParcelFileDescriptor pipeFrom(InputStream inputStream) throws IOException {
        ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
        ParcelFileDescriptor.AutoCloseOutputStream output = new ParcelFileDescriptor.AutoCloseOutputStream(pipe[1]);
        new TransferThread(inputStream, (OutputStream)output).start();
        return pipe[0];
    }

    public static ParcelFileDescriptor pipeTo(OutputStream outputStream) throws IOException {
        ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
        ParcelFileDescriptor.AutoCloseInputStream input = new ParcelFileDescriptor.AutoCloseInputStream(pipe[0]);
        new TransferThread((InputStream)input, outputStream).start();
        return pipe[1];
    }

    static class TransferThread
    extends Thread {
        final InputStream mIn;
        final OutputStream mOut;

        TransferThread(InputStream in, OutputStream out) {
            super("ParcelFileDescriptor Transfer Thread");
            this.mIn = in;
            this.mOut = out;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                IOUtils.copy((InputStream)this.mIn, (OutputStream)this.mOut);
                this.mOut.flush();
            }
            catch (IOException e) {
                Log.e((String)"TransferThread", (String)"writing failed");
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.mIn);
                IOUtils.closeQuietly((OutputStream)this.mOut);
            }
        }
    }
}

