/*
 * Decompiled with CFR 0.152.
 */
package com.github.microwww.redis.database;

import com.github.microwww.redis.database.Bytes;
import com.github.microwww.redis.protocal.operation.PubSubOperation;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;

public class PubSub
implements Closeable {
    public final NewChannelNotify newChannelNotify = new NewChannelNotify();
    private Map<Bytes, MessageChannel> channels = new HashMap<Bytes, MessageChannel>();

    public int publish(Bytes channel, Bytes message) {
        MessageChannel notify = this.getOrNewMessageNotify(channel);
        return notify.notify(message);
    }

    private synchronized MessageChannel getOrNewMessageNotify(Bytes channel) {
        MessageChannel mn = this.channels.get(channel);
        if (mn == null) {
            mn = new MessageChannel(channel);
            this.channels.put(channel, mn);
            this.newChannelNotify.notify(channel);
        }
        return mn;
    }

    public void subscribe(Bytes channel, Observer o) {
        this.getOrNewMessageNotify(channel).addObserver(o);
    }

    public void unsubscribe(Bytes channel, Observer o) {
        Observable obs = this.channels.get(channel);
        if (obs != null) {
            obs.deleteObserver(o);
        }
    }

    public synchronized Map<Bytes, MessageChannel> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    @Override
    public void close() throws IOException {
        this.channels.clear();
    }

    public static boolean isPatten(Observer observer) {
        if (observer instanceof PubSubOperation.ChannelMessageListener) {
            PubSubOperation.ChannelMessageListener pc = (PubSubOperation.ChannelMessageListener)observer;
            return pc.getPatten().isPresent();
        }
        return false;
    }

    public static Optional<Bytes> getNewPatten(Observer observer) {
        if (observer instanceof PubSubOperation.NewChannelListener) {
            PubSubOperation.NewChannelListener pc = (PubSubOperation.NewChannelListener)observer;
            return Optional.of(pc.getPatten());
        }
        return Optional.empty();
    }

    public class NewChannelNotify
    extends Observable {
        private List<Bytes> pattens = new ArrayList<Bytes>();

        public int notify(Bytes channel) {
            this.setChanged();
            this.notifyObservers(channel);
            return this.countObservers();
        }

        public void subscribe(Observer o) {
            PubSub.this.newChannelNotify.addObserver(o);
            PubSub.this.channels.values().forEach(e -> o.update(this, ((MessageChannel)e).channel));
        }

        public void unsubscribe(Observer o) {
            PubSub.this.newChannelNotify.deleteObserver(o);
        }

        @Override
        public synchronized void addObserver(Observer o) {
            int i = this.countObservers();
            super.addObserver(o);
            if (this.countObservers() != i) {
                PubSub.getNewPatten(o).ifPresent(this.pattens::add);
            }
        }

        @Override
        public synchronized void deleteObserver(Observer o) {
            int i = this.countObservers();
            super.deleteObserver(o);
            if (this.countObservers() != i) {
                PubSub.getNewPatten(o).ifPresent(this.pattens::remove);
            }
        }

        @Override
        public synchronized void deleteObservers() {
            super.deleteObservers();
            this.pattens.clear();
        }

        public List<Bytes> getPattens() {
            return Collections.unmodifiableList(this.pattens);
        }
    }

    public static class MessageChannel
    extends Observable {
        private final Bytes channel;
        private int numsub = 0;

        public MessageChannel(Bytes channel) {
            this.channel = channel;
        }

        public Bytes getChannel() {
            return this.channel;
        }

        public int notify(Bytes message) {
            this.setChanged();
            this.notifyObservers(message);
            return this.countObservers();
        }

        @Override
        public void addObserver(Observer o) {
            int i = this.countObservers();
            super.addObserver(o);
            if (this.countObservers() != i && !PubSub.isPatten(o)) {
                ++this.numsub;
            }
        }

        @Override
        public void deleteObserver(Observer o) {
            int i = this.countObservers();
            super.deleteObserver(o);
            if (this.countObservers() != i && !PubSub.isPatten(o)) {
                ++this.numsub;
            }
        }

        @Override
        public synchronized void deleteObservers() {
            super.deleteObservers();
            this.numsub = 0;
        }

        public int getNumsub() {
            return this.numsub;
        }

        public boolean isActive() {
            return this.getNumsub() > 0;
        }
    }
}

