/*
 * Decompiled with CFR 0.152.
 */
package br.com.madeinlabs.dropsky;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.RelativeLayout;
import br.com.madeinlabs.dropsky.DropSkyAdapter;
import br.com.madeinlabs.dropsky.DropSkyItem;
import java.util.LinkedList;

public class DropSkyLayout
extends RelativeLayout {
    private DropSkyAdapter mAdapter;
    private DropSkyListener mListener = new EmptyDropSkyListener();
    private boolean isChanging = false;
    private TimeInterpolator mInterpolatorByItem = new LinearInterpolator();

    public DropSkyLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAdapter(DropSkyAdapter adapter) {
        this.mAdapter = adapter;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        layoutParams.height = this.mAdapter.getTotalHeight();
    }

    public boolean hide(int hideDuration) {
        if (!this.isChanging) {
            this.isChanging = true;
            int translateYValue = -this.mAdapter.getTotalHeight();
            boolean reverse = this.mAdapter.isReverse();
            if (reverse) {
                translateYValue = -translateYValue;
            }
            if (hideDuration > 0) {
                this.animate().setDuration((long)hideDuration).translationY((float)translateYValue).setListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animator) {
                    }

                    public void onAnimationEnd(Animator animator) {
                        DropSkyLayout.this.isChanging = false;
                        DropSkyLayout.this.mListener.onHideEnd();
                    }

                    public void onAnimationCancel(Animator animator) {
                    }

                    public void onAnimationRepeat(Animator animator) {
                    }
                });
            } else {
                this.setTranslationY(translateYValue);
                this.isChanging = false;
            }
            return true;
        }
        return false;
    }

    public void hide() {
        this.hide(0);
    }

    public void show() {
        this.show(0L);
    }

    public boolean show(long duration) {
        if (!this.isChanging) {
            this.isChanging = true;
            if (this.getChildCount() > 0) {
                this.removeAllViews();
            }
            this.setTranslationY(0.0f);
            int countTotalItems = this.mAdapter.getCount();
            int index = this.mAdapter.isReverse() ? 0 : countTotalItems - 1;
            LinkedList<ObjectAnimator> animators = new LinkedList<ObjectAnimator>();
            while (index >= 0 && index < countTotalItems) {
                int finalY;
                final DropSkyItem dropSkyItem = this.mAdapter.getDropSkyItem(index);
                this.addView((View)dropSkyItem);
                ViewGroup.LayoutParams layoutParams = dropSkyItem.getLayoutParams();
                layoutParams.height = this.mAdapter.getTotalHeight();
                if (this.mAdapter.isReverse()) {
                    finalY = this.mAdapter.getItemY(index);
                } else {
                    int countItemsAlreadyDropped = countTotalItems - (index + 1);
                    int sizeAlreadyOccupied = this.mAdapter.getItemY(countItemsAlreadyDropped);
                    finalY = -sizeAlreadyOccupied;
                }
                if (duration == 0L) {
                    this.onStartShowingItem(dropSkyItem, index);
                    dropSkyItem.setTranslationY(finalY);
                    this.onEndShowingItem(dropSkyItem, index);
                } else {
                    int initialY = this.mAdapter.isReverse() ? this.getHeight() : -this.getHeight();
                    long itemShowDuration = duration / (long)countTotalItems;
                    dropSkyItem.setTranslationY(initialY);
                    ObjectAnimator animator = ObjectAnimator.ofFloat((Object)((Object)dropSkyItem), (Property)View.TRANSLATION_Y, (float[])new float[]{initialY, finalY});
                    animator.setDuration(itemShowDuration);
                    animator.setInterpolator(this.mInterpolatorByItem);
                    animators.add(animator);
                    final int finalI = index;
                    animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationStart(Animator animator) {
                            DropSkyLayout.this.onStartShowingItem(dropSkyItem, finalI);
                        }

                        public void onAnimationEnd(Animator animator) {
                            DropSkyLayout.this.onEndShowingItem(dropSkyItem, finalI);
                        }
                    });
                }
                if (this.mAdapter.isReverse()) {
                    ++index;
                    continue;
                }
                --index;
            }
            AnimatorSet animatorSet = new AnimatorSet();
            animatorSet.playSequentially(animators);
            animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    DropSkyLayout.this.mListener.onShowEnd();
                    DropSkyLayout.this.isChanging = false;
                }
            });
            animatorSet.start();
            return true;
        }
        return false;
    }

    private void onStartShowingItem(DropSkyItem dropSkyItem, int i) {
        this.mListener.onItemShowStart((View)dropSkyItem.mViewContainer, i);
    }

    private void onEndShowingItem(DropSkyItem dropSkyItem, int index) {
        this.mListener.onItemShowEnd((View)dropSkyItem.mViewContainer, index);
    }

    public void setListener(DropSkyListener listener) {
        this.mListener = listener != null ? listener : new EmptyDropSkyListener();
    }

    public DropSkyAdapter getAdapter() {
        return this.mAdapter;
    }

    public void setItemInterpolator(TimeInterpolator itemInterpolator) {
        this.mInterpolatorByItem = itemInterpolator;
    }

    private class EmptyDropSkyListener
    implements DropSkyListener {
        private EmptyDropSkyListener() {
        }

        @Override
        public void onItemShowEnd(View view, int index) {
        }

        @Override
        public void onItemShowStart(View view, int index) {
        }

        @Override
        public void onShowEnd() {
        }

        @Override
        public void onHideEnd() {
        }
    }

    public static interface DropSkyListener {
        public void onItemShowEnd(View var1, int var2);

        public void onItemShowStart(View var1, int var2);

        public void onShowEnd();

        public void onHideEnd();
    }
}

