/*
 * Decompiled with CFR 0.152.
 */
package br.com.madeinlabs.dropsky;

import android.animation.Animator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.widget.RelativeLayout;
import br.com.madeinlabs.dropsky.DropSkyAdapter;
import br.com.madeinlabs.dropsky.DropSkyItem;

public class DropSkyLayout
extends RelativeLayout {
    private DropSkyAdapter mAdapter;
    private int mNextViewIndex;
    private float mGround;
    private long mDropDuration;
    private DropSkyListener mListener;

    public DropSkyLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setAdapter(DropSkyAdapter adapter) {
        this.mAdapter = adapter;
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        layoutParams.height = this.mAdapter.getTotalHeight();
    }

    public void drop() {
        this.drop(0L);
    }

    public void drop(long duration) {
        this.setTranslationY(0.0f);
        if (this.getChildCount() > 0) {
            this.removeAllViews();
        }
        this.mNextViewIndex = this.mAdapter.getCount() - 1;
        this.mDropDuration = duration;
        this.mGround = 0.0f;
        this.dropItem();
    }

    private void dropItem() {
        if (this.mNextViewIndex >= 0) {
            final DropSkyItem dropSkyItem = this.mAdapter.getDropSkyItem(this.mNextViewIndex);
            this.addView((View)dropSkyItem);
            ViewGroup.LayoutParams layoutParams = dropSkyItem.getLayoutParams();
            layoutParams.height = this.mAdapter.getTotalHeight();
            dropSkyItem.setTranslationY(-this.getHeight());
            long currentDropDuration = this.mDropDuration / (long)this.mAdapter.getCount();
            ViewPropertyAnimator animator = dropSkyItem.animate().translationY(this.mGround).setDuration(currentDropDuration);
            --this.mNextViewIndex;
            animator.setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animator) {
                    if (DropSkyLayout.this.mListener != null) {
                        DropSkyLayout.this.mListener.onItemDropStart((View)dropSkyItem.mViewContainer, DropSkyLayout.this.mNextViewIndex + 1);
                    }
                }

                public void onAnimationEnd(Animator animator) {
                    if (DropSkyLayout.this.mListener != null) {
                        DropSkyLayout.this.mListener.onItemDropEnd((View)dropSkyItem.mViewContainer, DropSkyLayout.this.mNextViewIndex + 1);
                    }
                    DropSkyLayout.this.mGround = DropSkyLayout.this.mGround - (float)dropSkyItem.getTrueHeight();
                    DropSkyLayout.this.dropItem();
                }

                public void onAnimationCancel(Animator animator) {
                }

                public void onAnimationRepeat(Animator animator) {
                }
            });
        } else if (this.mListener != null) {
            this.mListener.onDropEnd();
        }
    }

    public void setListener(DropSkyListener listener) {
        this.mListener = listener;
    }

    public void fly(int flyDuration) {
        this.animate().setDuration((long)flyDuration).translationY((float)(-this.mAdapter.getTotalHeight()));
    }

    public static interface DropSkyListener {
        public void onItemDropEnd(View var1, int var2);

        public void onItemDropStart(View var1, int var2);

        public void onDropEnd();
    }
}

