/*
 * Decompiled with CFR 0.152.
 */
package br.com.madeinlabs.dropsky;

import android.content.Context;
import android.view.View;
import br.com.madeinlabs.dropsky.DropSkyItem;
import java.util.LinkedList;
import java.util.List;

public class DropSkyAdapter {
    private final Context mContext;
    private List<DropSkyItem> mDropSkyItems = new LinkedList<DropSkyItem>();
    private int totalHeight;
    private Listener mListener;

    public DropSkyAdapter(Context context) {
        this.mContext = context;
    }

    public int getCount() {
        return this.mDropSkyItems.size();
    }

    public DropSkyItem getDropSkyItem(int index) {
        return this.mDropSkyItems.get(index);
    }

    public void addViewItem(View view, int color) {
        final DropSkyItem dropSkyItem = new DropSkyItem(this.mContext, view, color);
        view.measure(0, 0);
        this.totalHeight += view.getMeasuredHeight();
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (DropSkyAdapter.this.mListener != null) {
                    DropSkyAdapter.this.mListener.onItemClicked(dropSkyItem, DropSkyAdapter.this.mDropSkyItems.indexOf((Object)dropSkyItem));
                }
            }
        });
        this.mDropSkyItems.add(dropSkyItem);
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public void setOnItemClickListener(Listener onItemClickListener) {
        this.mListener = onItemClickListener;
    }

    public static interface Listener {
        public void onItemClicked(DropSkyItem var1, int var2);
    }
}

