/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip.util;

import android.app.Activity;
import android.graphics.Rect;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.SearchEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.InputMethodManager;
import edu.ben.materialchip.views.ChipsInputEditText;
import edu.ben.materialchip.views.DetailedChipView;

public class MyWindowCallback
implements Window.Callback {
    private Window.Callback mLocalCallback;
    private Activity mActivity;

    public MyWindowCallback(Window.Callback localCallback, Activity activity) {
        this.mLocalCallback = localCallback;
        this.mActivity = activity;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return this.mLocalCallback.dispatchKeyEvent(keyEvent);
    }

    public boolean dispatchKeyShortcutEvent(KeyEvent keyEvent) {
        return this.mLocalCallback.dispatchKeyShortcutEvent(keyEvent);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            Rect outRect;
            View v = this.mActivity.getCurrentFocus();
            if (v instanceof DetailedChipView) {
                outRect = new Rect();
                v.getGlobalVisibleRect(outRect);
                if (!outRect.contains((int)motionEvent.getRawX(), (int)motionEvent.getRawY())) {
                    ((DetailedChipView)v).fadeOut();
                }
            }
            if (v instanceof ChipsInputEditText) {
                outRect = new Rect();
                v.getGlobalVisibleRect(outRect);
                if (!outRect.contains((int)motionEvent.getRawX(), (int)motionEvent.getRawY()) && !((ChipsInputEditText)v).isFilterableListVisible()) {
                    InputMethodManager imm = (InputMethodManager)this.mActivity.getSystemService("input_method");
                    imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
                }
            }
        }
        return this.mLocalCallback.dispatchTouchEvent(motionEvent);
    }

    public boolean dispatchTrackballEvent(MotionEvent motionEvent) {
        return this.mLocalCallback.dispatchTrackballEvent(motionEvent);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        return this.mLocalCallback.dispatchGenericMotionEvent(motionEvent);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return this.mLocalCallback.dispatchPopulateAccessibilityEvent(accessibilityEvent);
    }

    @Nullable
    public View onCreatePanelView(int i) {
        return this.mLocalCallback.onCreatePanelView(i);
    }

    public boolean onCreatePanelMenu(int i, Menu menu) {
        return this.mLocalCallback.onCreatePanelMenu(i, menu);
    }

    public boolean onPreparePanel(int i, View view, Menu menu) {
        return this.mLocalCallback.onPreparePanel(i, view, menu);
    }

    public boolean onMenuOpened(int i, Menu menu) {
        return this.mLocalCallback.onMenuOpened(i, menu);
    }

    public boolean onMenuItemSelected(int i, MenuItem menuItem) {
        return this.mLocalCallback.onMenuItemSelected(i, menuItem);
    }

    public void onWindowAttributesChanged(WindowManager.LayoutParams layoutParams) {
        this.mLocalCallback.onWindowAttributesChanged(layoutParams);
    }

    public void onContentChanged() {
        this.mLocalCallback.onContentChanged();
    }

    public void onWindowFocusChanged(boolean b) {
        this.mLocalCallback.onWindowFocusChanged(b);
    }

    public void onAttachedToWindow() {
        this.mLocalCallback.onAttachedToWindow();
    }

    public void onDetachedFromWindow() {
        this.mLocalCallback.onDetachedFromWindow();
    }

    public void onPanelClosed(int i, Menu menu) {
        this.mLocalCallback.onPanelClosed(i, menu);
    }

    public boolean onSearchRequested() {
        return this.mLocalCallback.onSearchRequested();
    }

    @RequiresApi(api=23)
    public boolean onSearchRequested(SearchEvent searchEvent) {
        return this.mLocalCallback.onSearchRequested(searchEvent);
    }

    @Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback) {
        return this.mLocalCallback.onWindowStartingActionMode(callback);
    }

    @RequiresApi(api=23)
    @Nullable
    public ActionMode onWindowStartingActionMode(ActionMode.Callback callback, int i) {
        return this.mLocalCallback.onWindowStartingActionMode(callback, i);
    }

    public void onActionModeStarted(ActionMode actionMode) {
        this.mLocalCallback.onActionModeStarted(actionMode);
    }

    public void onActionModeFinished(ActionMode actionMode) {
        this.mLocalCallback.onActionModeFinished(actionMode);
    }
}

