/*
 * Decompiled with CFR 0.152.
 */
package edu.ben.materialchip.util;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.content.ContextCompat;
import android.text.TextPaint;
import edu.ben.materialchip.R;
import edu.ben.materialchip.util.ViewUtil;

public class LetterTileProvider {
    private static final int NUM_OF_TILE_COLORS = 8;
    private final TextPaint mPaint = new TextPaint();
    private final Rect mBounds = new Rect();
    private final Canvas mCanvas = new Canvas();
    private final char[] mFirstChar = new char[1];
    private final TypedArray mColors;
    private final int mTileLetterFontSize;
    private final Bitmap mDefaultBitmap;
    private final int mWidth;
    private final int mHeight;

    public LetterTileProvider(Context context) {
        Resources res = context.getResources();
        this.mPaint.setTypeface(Typeface.create((String)"sans-serif-light", (int)0));
        this.mPaint.setColor(-1);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setAntiAlias(true);
        this.mColors = res.obtainTypedArray(R.array.letter_tile_colors);
        this.mTileLetterFontSize = res.getDimensionPixelSize(R.dimen.tile_letter_font_size);
        this.mDefaultBitmap = LetterTileProvider.drawableToBitmap(ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_person_white_24dp));
        this.mWidth = res.getDimensionPixelSize(R.dimen.letter_tile_size);
        this.mHeight = res.getDimensionPixelSize(R.dimen.letter_tile_size);
    }

    public Bitmap getLetterTile(String displayName) {
        if (displayName == null || displayName.length() == 0) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        char firstChar = displayName.charAt(0);
        Canvas c = this.mCanvas;
        c.setBitmap(bitmap);
        c.drawColor(this.pickColor(displayName));
        if (LetterTileProvider.isLetterOrDigit(firstChar)) {
            this.mFirstChar[0] = Character.toUpperCase(firstChar);
            this.mPaint.setTextSize((float)this.mTileLetterFontSize);
            this.mPaint.getTextBounds(this.mFirstChar, 0, 1, this.mBounds);
            c.drawText(this.mFirstChar, 0, 1, (float)(this.mWidth / 2), (float)(this.mHeight / 2 + (this.mBounds.bottom - this.mBounds.top) / 2), (Paint)this.mPaint);
        } else {
            c.drawBitmap(this.mDefaultBitmap, (float)ViewUtil.dpToPx(4), (float)ViewUtil.dpToPx(4), null);
        }
        return bitmap;
    }

    public Bitmap getCircularLetterTile(String displayName) {
        if (displayName == null || displayName.length() == 0) {
            displayName = ".";
        }
        Bitmap bitmap = Bitmap.createBitmap((int)this.mWidth, (int)this.mHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        char firstChar = displayName.charAt(0);
        Canvas c = this.mCanvas;
        c.setBitmap(bitmap);
        c.drawColor(this.pickColor(displayName));
        if (LetterTileProvider.isLetterOrDigit(firstChar)) {
            this.mFirstChar[0] = Character.toUpperCase(firstChar);
            this.mPaint.setTextSize((float)this.mTileLetterFontSize);
            this.mPaint.getTextBounds(this.mFirstChar, 0, 1, this.mBounds);
            c.drawText(this.mFirstChar, 0, 1, (float)(this.mWidth / 2), (float)(this.mHeight / 2 + (this.mBounds.bottom - this.mBounds.top) / 2), (Paint)this.mPaint);
        } else {
            c.drawBitmap(this.mDefaultBitmap, (float)ViewUtil.dpToPx(4), (float)ViewUtil.dpToPx(4), null);
        }
        return this.getCircularBitmap(bitmap);
    }

    private static boolean isLetterOrDigit(char c) {
        return Character.isLetterOrDigit(c);
    }

    private int pickColor(String key) {
        int color2 = Math.abs(key.hashCode()) % 8;
        return this.mColors.getColor(color2, -16777216);
    }

    private Bitmap getCircularBitmap(Bitmap bitmap) {
        Bitmap output = bitmap.getWidth() > bitmap.getHeight() ? Bitmap.createBitmap((int)bitmap.getHeight(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getWidth(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = -12434878;
        Paint paint = new Paint();
        Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());
        float r = 0.0f;
        r = bitmap.getWidth() > bitmap.getHeight() ? (float)(bitmap.getHeight() / 2) : (float)(bitmap.getWidth() / 2);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawCircle(r, r, r, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, rect, rect, paint);
        return output;
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        BitmapDrawable bitmapDrawable;
        Bitmap bitmap = null;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable2).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        bitmap = drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0 ? Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap;
    }
}

