/*
 * Decompiled with CFR 0.152.
 */
package com.github.lzyzsd.jsbridge;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.github.lzyzsd.jsbridge.BridgeHandler;
import com.github.lzyzsd.jsbridge.BridgeUtil;
import com.github.lzyzsd.jsbridge.CallBackFunction;
import com.github.lzyzsd.jsbridge.DefaultHandler;
import com.github.lzyzsd.jsbridge.Message;
import com.github.lzyzsd.jsbridge.WebViewJavascriptBridge;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class BridgeWebView
extends WebView
implements WebViewJavascriptBridge {
    private final String TAG = "BridgeWebView";
    String toLoadJs = "WebViewJavascriptBridge.js";
    Map<String, CallBackFunction> responseCallbacks = new HashMap<String, CallBackFunction>();
    Map<String, BridgeHandler> messageHandlers = new HashMap<String, BridgeHandler>();
    BridgeHandler defaultHandler = new DefaultHandler();
    List<Message> startupMessage = new ArrayList<Message>();
    long uniqueId = 0L;

    public BridgeWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public BridgeWebView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public BridgeWebView(Context context) {
        super(context);
        this.init();
    }

    public void setDefaultHandler(BridgeHandler handler) {
        this.defaultHandler = handler;
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
        this.setHorizontalScrollBarEnabled(false);
        this.getSettings().setJavaScriptEnabled(true);
        if (Build.VERSION.SDK_INT >= 19) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
        this.setWebViewClient(new BridgeWebViewClient());
    }

    private void handlerReturnData(String url) {
        String functionName = BridgeUtil.getFunctionFromReturnUrl(url);
        CallBackFunction f = this.responseCallbacks.get(functionName);
        String data = BridgeUtil.getDataFromReturnUrl(url);
        if (f != null) {
            f.onCallBack(data);
            this.responseCallbacks.remove(functionName);
            return;
        }
    }

    @Override
    public void send(String data) {
        this.send(data, null);
    }

    @Override
    public void send(String data, CallBackFunction responseCallback) {
        this.doSend(null, data, responseCallback);
    }

    private void doSend(String handlerName, String data, CallBackFunction responseCallback) {
        Message m = new Message();
        if (!TextUtils.isEmpty((CharSequence)data)) {
            m.setData(data);
        }
        if (responseCallback != null) {
            String callbackStr = String.format("JAVA_CB_%s", ++this.uniqueId + "_" + SystemClock.currentThreadTimeMillis());
            this.responseCallbacks.put(callbackStr, responseCallback);
            m.setCallbackId(callbackStr);
        }
        if (!TextUtils.isEmpty((CharSequence)handlerName)) {
            m.setHandlerName(handlerName);
        }
        this.queueMessage(m);
    }

    private void queueMessage(Message m) {
        if (this.startupMessage != null) {
            this.startupMessage.add(m);
        } else {
            this.dispatchMessage(m);
        }
    }

    private void dispatchMessage(Message m) {
        String messageJson = m.toJson();
        messageJson = messageJson.replaceAll("(\\\\)([^utrn])", "\\\\\\\\$1$2");
        messageJson = messageJson.replaceAll("(?<=[^\\\\])(\")", "\\\\\"");
        String javascriptCommand = String.format("javascript:WebViewJavascriptBridge._handleMessageFromNative('%s');", messageJson);
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.loadUrl(javascriptCommand);
        }
    }

    public void flushMessageQueue() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.loadUrl("javascript:WebViewJavascriptBridge._fetchQueue();", new CallBackFunction(){

                @Override
                public void onCallBack(String data) {
                    List<Message> list = null;
                    try {
                        list = Message.toArrayList(data);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    if (list == null || list.size() == 0) {
                        return;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        Message m = list.get(i);
                        String responseId = m.getResponseId();
                        if (!TextUtils.isEmpty((CharSequence)responseId)) {
                            CallBackFunction function = BridgeWebView.this.responseCallbacks.get(responseId);
                            String responseData = m.getResponseData();
                            function.onCallBack(responseData);
                            BridgeWebView.this.responseCallbacks.remove(responseId);
                            continue;
                        }
                        CallBackFunction responseFunction = null;
                        final String callbackId = m.getCallbackId();
                        responseFunction = !TextUtils.isEmpty((CharSequence)callbackId) ? new CallBackFunction(){

                            @Override
                            public void onCallBack(String data) {
                                Message responseMsg = new Message();
                                responseMsg.setResponseId(callbackId);
                                responseMsg.setResponseData(data);
                                BridgeWebView.this.queueMessage(responseMsg);
                            }
                        } : new CallBackFunction(){

                            @Override
                            public void onCallBack(String data) {
                            }
                        };
                        BridgeHandler handler = !TextUtils.isEmpty((CharSequence)m.getHandlerName()) ? BridgeWebView.this.messageHandlers.get(m.getHandlerName()) : BridgeWebView.this.defaultHandler;
                        handler.handler(m.getData(), responseFunction);
                    }
                }
            });
        }
    }

    public void loadUrl(String jsUrl, CallBackFunction returnCallback) {
        this.loadUrl(jsUrl);
        this.responseCallbacks.put(BridgeUtil.parseFunctionName(jsUrl), returnCallback);
    }

    public void registerHandler(String handlerName, BridgeHandler handler) {
        if (handler != null) {
            this.messageHandlers.put(handlerName, handler);
        }
    }

    public void callHandler(String handlerName, String data, CallBackFunction callBack) {
        this.doSend(handlerName, data, callBack);
    }

    class BridgeWebViewClient
    extends WebViewClient {
        BridgeWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            try {
                url = URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (url.startsWith("yy://return/")) {
                BridgeWebView.this.handlerReturnData(url);
                return true;
            }
            if (url.startsWith("yy://")) {
                BridgeWebView.this.flushMessageQueue();
                return true;
            }
            return super.shouldOverrideUrlLoading(view, url);
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            if (BridgeWebView.this.toLoadJs != null) {
                BridgeUtil.webViewLoadLocalJs(view, BridgeWebView.this.toLoadJs);
            }
            if (BridgeWebView.this.startupMessage != null) {
                for (Message m : BridgeWebView.this.startupMessage) {
                    BridgeWebView.this.dispatchMessage(m);
                }
                BridgeWebView.this.startupMessage = null;
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
        }
    }
}

