/*
 * Decompiled with CFR 0.152.
 */
package com.lwjfork.code.cusor;

import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import com.lwjfork.code.base.BaseDrawer;

public class CursorDrawer
extends BaseDrawer {
    private boolean showCursor;
    private int cursorDuration;
    private int cursorWidth;
    private int cursorHeight;
    @ColorInt
    private int cursorColor;
    private Paint cursorPaint;

    public CursorDrawer(boolean showCursor, int cursorDuration, int cursorWidth, int cursorHeight, int cursorColor) {
        this.showCursor = showCursor;
        this.cursorDuration = cursorDuration;
        this.cursorWidth = cursorWidth;
        this.cursorColor = cursorColor;
        this.cursorHeight = cursorHeight;
        this.iniPaint();
    }

    private void iniPaint() {
        this.cursorPaint = new Paint();
        this.cursorPaint.setAntiAlias(true);
        this.cursorPaint.setColor(this.cursorColor);
        this.cursorPaint.setStyle(Paint.Style.FILL);
        this.cursorPaint.setStrokeWidth((float)this.cursorWidth);
    }

    @Override
    public void setFocused(boolean isFocused) {
        super.setFocused(isFocused);
    }

    @Override
    public void drawCanvas() {
        this.drawCursor();
    }

    private void drawCursorLine() {
        int padding;
        int startX;
        Rect rect = (Rect)this.blockRects.get(this.currentBlockIndex);
        int endX = startX = rect.centerX() - this.cursorWidth / 2;
        int startY = padding = Math.max((rect.height() - this.cursorHeight) / 2, 0);
        int endY = startY + this.cursorHeight;
        this.canvas.drawLine((float)startX, (float)startY, (float)endX, (float)endY, this.cursorPaint);
    }

    private void clearCursor() {
        this.clearCanvas(this.canvas);
    }

    public void drawCursor() {
        if (!this.showCursor) {
            this.clearCursor();
            return;
        }
        if (!this.isFocused()) {
            this.clearCursor();
            return;
        }
        if (this.currentBlockIndex >= this.blockRects.size()) {
            this.clearCursor();
            return;
        }
        this.clearCanvas(this.canvas);
        this.drawCursorLine();
    }

    public void cancelCursor() {
        this.clearCanvas(this.canvas);
    }

    public boolean isShowCursor() {
        return this.showCursor && this.isFocused() && this.currentBlockIndex < this.blockRects.size();
    }

    public void setShowCursor(boolean showCursor) {
        this.showCursor = showCursor;
    }

    public int getCursorDuration() {
        return this.cursorDuration;
    }

    public void setCursorDuration(int cursorDuration) {
        this.cursorDuration = cursorDuration;
    }

    public int getCursorWidth() {
        return this.cursorWidth;
    }

    public void setCursorWidth(int cursorWidth) {
        this.cursorWidth = cursorWidth;
    }

    public int getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(int cursorColor) {
        this.cursorColor = cursorColor;
    }

    @Override
    public void setCurrentBlockIndex(int currentBlockIndex) {
        super.setCurrentBlockIndex(currentBlockIndex);
    }
}

