/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.github.loki4j.common.ByteBufferFactory;
import com.github.loki4j.common.LogRecord;
import com.github.loki4j.common.LogRecordStream;
import com.github.loki4j.common.Writer;
import com.github.loki4j.logback.Loki4jEncoder;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public abstract class AbstractLoki4jEncoder
extends ContextAwareBase
implements Loki4jEncoder {
    private static final String STATIC_STREAM_KEY = "STATIC_STREAM_KEY";
    private static final Comparator<LogRecord> byTime = (e1, e2) -> {
        int tsCmp = Long.compare(e1.timestampMs, e2.timestampMs);
        return tsCmp == 0 ? Integer.compare(e1.nanos, e2.nanos) : tsCmp;
    };
    private static final Comparator<LogRecord> byStream = (e1, e2) -> Long.compare(e1.stream.id, e2.stream.id);
    protected final Charset charset = Charset.forName("UTF-8");
    private final AtomicReference<HashMap<String, LogRecordStream>> streams = new AtomicReference(new HashMap());
    private final AtomicInteger nanoCounter = new AtomicInteger(0);
    private LabelCfg label = new LabelCfg();
    private MessageCfg message = new MessageCfg();
    private Optional<Comparator<LogRecord>> logRecordComparator;
    private boolean sortByTime = false;
    private volatile boolean staticLabels = false;
    private volatile long maxTimestampMs = 0L;
    private PatternLayout labelPatternLayout;
    private PatternLayout messagePatternLayout;
    private boolean started = false;

    public void start() {
        String resolvedLblPat = this.label.pattern == null ? "level=%level,host=" + this.context.getProperty("HOSTNAME") : this.label.pattern;
        String labelPattern = this.label.nopex ? resolvedLblPat + "%nopex" : resolvedLblPat;
        this.labelPatternLayout = this.initPatternLayout(labelPattern);
        this.labelPatternLayout.start();
        this.messagePatternLayout = this.initPatternLayout(this.message.pattern);
        this.messagePatternLayout.start();
        this.logRecordComparator = Optional.empty();
        if (this.staticLabels) {
            if (this.sortByTime) {
                this.logRecordComparator = Optional.of(byTime);
            }
        } else {
            this.logRecordComparator = Optional.of(this.sortByTime ? byStream.thenComparing(byTime) : byStream);
        }
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.messagePatternLayout.stop();
        this.labelPatternLayout.stop();
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public LogRecordStream eventToStream(ILoggingEvent e) {
        return this.stream(this.labelPatternLayout.doLayout(e).intern());
    }

    @Override
    public String eventToMessage(ILoggingEvent e) {
        return this.messagePatternLayout.doLayout(e);
    }

    @Override
    public int timestampToNanos(long timestampMs) {
        long nextMs = timestampMs % 1000L;
        if (this.maxTimestampMs > timestampMs) {
            return (int)nextMs * 1000 + 999;
        }
        int nanos = this.nanoCounter.updateAndGet(i -> {
            if (this.maxTimestampMs == timestampMs) {
                if (i % 1000 < 999) {
                    return i + 1;
                }
                return i;
            }
            return (int)nextMs * 1000;
        });
        this.maxTimestampMs = timestampMs;
        return nanos;
    }

    @Override
    public abstract Writer createWriter(int var1, ByteBufferFactory var2);

    private PatternLayout initPatternLayout(String pattern) {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(this.context);
        patternLayout.setPattern(pattern);
        return patternLayout;
    }

    private LogRecordStream stream(String input) {
        String streamKey = this.staticLabels ? STATIC_STREAM_KEY : input;
        return this.streams.updateAndGet(m -> {
            if (!m.containsKey(streamKey)) {
                HashMap<String, LogRecordStream> nm = new HashMap<String, LogRecordStream>((Map<String, LogRecordStream>)m);
                nm.put(streamKey, LogRecordStream.create(m.size(), this.extractStreamKVPairs(input)));
                return nm;
            }
            return m;
        }).get(streamKey);
    }

    String[] extractStreamKVPairs(String stream) {
        String[] pairs = stream.split(Pattern.quote(this.label.pairSeparator));
        String[] result = new String[pairs.length * 2];
        for (int i = 0; i < pairs.length; ++i) {
            String[] kv = pairs[i].split(Pattern.quote(this.label.keyValueSeparator));
            if (kv.length != 2) {
                throw new IllegalArgumentException(String.format("Unable to split '%s' in '%s' to label key-value pairs, pairSeparator=%s, keyValueSeparator=%s", pairs[i], stream, this.label.pairSeparator, this.label.keyValueSeparator));
            }
            result[i * 2] = kv[0];
            result[i * 2 + 1] = kv[1];
        }
        return result;
    }

    @Override
    public Optional<Comparator<LogRecord>> getLogRecordComparator() {
        return this.logRecordComparator;
    }

    public void setLabel(LabelCfg label) {
        this.label = label;
    }

    public void setMessage(MessageCfg message) {
        this.message = message;
    }

    public void setSortByTime(boolean sortByTime) {
        this.sortByTime = sortByTime;
    }

    public void setStaticLabels(boolean staticLabels) {
        this.staticLabels = staticLabels;
    }

    public static final class MessageCfg {
        String pattern = "l=%level c=%logger{20} t=%thread | %msg %ex";

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }
    }

    public static final class LabelCfg {
        String pattern;
        String pairSeparator = ",";
        String keyValueSeparator = "=";
        boolean nopex = true;

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public void setKeyValueSeparator(String keyValueSeparator) {
            this.keyValueSeparator = keyValueSeparator;
        }

        public void setPairSeparator(String pairSeparator) {
            this.pairSeparator = pairSeparator;
        }

        public void setNopex(boolean nopex) {
            this.nopex = nopex;
        }
    }
}

