/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.core.spi.ContextAwareBase;
import com.github.loki4j.logback.HttpSender;
import java.util.Base64;
import java.util.Optional;

public abstract class AbstractHttpSender
extends ContextAwareBase
implements HttpSender {
    protected String url = "http://localhost:3100/loki/api/v1/push";
    protected Optional<String> tenantId = Optional.empty();
    protected String contentType;
    protected long connectionTimeoutMs = 30000L;
    protected long requestTimeoutMs = 5000L;
    private BasicAuth auth;
    protected Optional<String> basicAuthToken = Optional.empty();
    private boolean started = false;

    public void start() {
        if (this.auth != null) {
            this.basicAuthToken = Optional.of(Base64.getEncoder().encodeToString((this.auth.username + ":" + this.auth.password).getBytes()));
        }
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setConnectionTimeoutMs(long connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setRequestTimeoutMs(long requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public void setAuth(BasicAuth auth) {
        this.auth = auth;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setTenantId(String tenant) {
        this.tenantId = Optional.ofNullable(tenant);
    }

    public static final class BasicAuth {
        String username;
        String password;

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

