/*
 * Decompiled with CFR 0.152.
 */
package com.lin.utils;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Random;

public final class RandomUtils {
    private static final Random RANDOM = new Random();
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static int randomByLength(int len) {
        return RANDOM.nextInt(len);
    }

    public static <T> T selectOneInArray(T[] array) {
        int index = RandomUtils.randomByLength(array.length);
        return array[index];
    }

    public static <T> T selectOneInList(List<T> dataList) {
        int index = RandomUtils.randomByLength(dataList.size());
        return dataList.get(index);
    }

    private static void checkNumberValid(Double start, Double end) {
        if (start > end) {
            throw new RuntimeException("\u8d77\u59cb\u503c\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u503c");
        }
        if (start < 0.0) {
            throw new RuntimeException("\u8d77\u59cb\u503c\u5fc5\u987b\u5927\u4e8e0");
        }
    }

    public static int nextIntRange(int start, int end) {
        RandomUtils.checkNumberValid(Double.valueOf(start), Double.valueOf(end));
        return RANDOM.nextInt(end - start + 1) + start;
    }

    public static long nextLongRange(long start, long end) {
        return start == end ? start : (long)((double)start + (double)(end - start) * RANDOM.nextDouble());
    }

    public static float nextFloatRange(float start, float end) {
        return RandomUtils.nextFloatRange(start, end, 2);
    }

    public static float nextFloatRange(float start, float end, int precision) {
        RandomUtils.checkNumberValid(Double.valueOf(start), Double.valueOf(end));
        if (start == end) {
            return start;
        }
        int intValue = RandomUtils.nextIntRange((int)start, (int)end);
        BigDecimal bd = new BigDecimal(RANDOM.nextFloat());
        float floatValue = (bd = bd.setScale(precision, 3)).floatValue();
        float resultValue = (float)intValue + floatValue;
        resultValue = resultValue < start ? start : resultValue;
        resultValue = resultValue > end ? end : resultValue;
        return resultValue;
    }

    public static double nextDoubleRange(double start, double end) {
        return RandomUtils.nextDoubleRange(start, end, 2);
    }

    public static double nextDoubleRange(double start, double end, int precision) {
        RandomUtils.checkNumberValid(start, end);
        if (start == end) {
            return start;
        }
        int intValue = RandomUtils.nextIntRange((int)start, (int)end);
        BigDecimal bd = new BigDecimal(RANDOM.nextDouble());
        double doubleValue = (bd = bd.setScale(precision, 3)).doubleValue();
        double resultValue = (double)intValue + doubleValue;
        resultValue = resultValue < start ? start : resultValue;
        resultValue = resultValue > end ? end : resultValue;
        return resultValue;
    }

    public static String nextTimeRange(long startTime, long endTime) {
        RandomUtils.checkNumberValid(Double.valueOf(startTime), Double.valueOf(endTime));
        long timeValue = RandomUtils.nextLongRange(startTime, endTime);
        return DATE_FORMAT.format(timeValue);
    }
}

